<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTemplate\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class TemplateType extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * typeTablename
     *
     * @var string
     */
    protected $typeTablename = '';

    /**
     * mainTagTablename
     *
     * @var string
     */
    protected $mainTagTablename = '';

    /**
     * subTagTablename
     *
     * @var string
     */
    protected $subTagTablename = '';

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * cssFile
     *
     * @var string
     */
    protected $cssFile = '';

    /**
     * pageClass
     *
     * @var string
     */
    protected $pageClass = '';

    /**
     * templateFilename
     *
     * @var string
     */
    protected $templateFilename = '';

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the typeTablename
     *
     * @return string
     */
    public function getTypeTablename()
    {
        return $this->typeTablename;
    }

    /**
     * Sets the typeTablename
     */
    public function setTypeTablename(string $typeTablename): void
    {
        $this->typeTablename = $typeTablename;
    }

    /**
     * Returns the mainTagTablename
     *
     * @return string
     */
    public function getMainTagTablename()
    {
        return $this->mainTagTablename;
    }

    /**
     * Sets the mainTagTablename
     */
    public function setMainTagTablename(string $mainTagTablename): void
    {
        $this->mainTagTablename = $mainTagTablename;
    }

    /**
     * Returns the subTagTablename
     *
     * @return string
     */
    public function getSubTagTablename()
    {
        return $this->subTagTablename;
    }

    /**
     * Sets the subTagTablename
     */
    public function setSubTagTablename(string $subTagTablename): void
    {
        $this->subTagTablename = $subTagTablename;
    }

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the cssFile
     *
     * @return string
     */
    public function getCssFile()
    {
        return $this->cssFile;
    }

    /**
     * Sets the cssFile
     */
    public function setCssFile(string $cssFile): void
    {
        $this->cssFile = $cssFile;
    }
    
    /**
     * Returns the pageClass
     */
    public function getPageClass(): string
    {
        return $this->pageClass;
    }

    /**
     * Sets the pageClass
     */
    public function setPageClass(string $pageClass): void
    {
        $this->pageClass = $pageClass;
    }
    public function getTemplateFilename()
    {
        return $this->templateFilename ?: 'TemplateLetter/Default.html';
    }
    /**
     * Sets the templateFilename
     */
    public function setTemplateFilename(string $templateFilename): void
    {
        $this->templateFilename = $templateFilename;
    }
}
