<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Model;

use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser as IgFrontendUser;

class FrontendUser extends IgFrontendUser implements AddressInterface
{
    public function getLanguageCode()
    {
        return 'de';
    }
    public function getIsOrganisation()
    {
        return false;
    }
    public function getOrganisationName()
    {
        return '';
    }

    public function getType()
    {
        return 'Person';
    }
    public function getInvoiceEmail()
    {
        return $this->getEmail();
    }
    public function getNumber()
    {
        return $this->getUid();
    }
    public function getAddress2()
    {
        return $this->getZip() . ' ' . $this->getCity();
    }
    public function getAddress3()
    {
        return '';
    }
    public function getAddon()
    {
        return '';
    }
    public function getPoboxText()
    {
        return '';
    }
    public function getCountryIsoCode()
    {
        return 'CH';
    }
    public function getCountryPostalCode()
    {
        return $this->getZip();
    }
    public function getAgeInYear()
    {
        return 20;
    }
}
