<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity',
        'label' => 'name',
        'sortby' => 'sorting',
        //'default_sortby' => 'ORDER BY name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => false,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
        ],
        'searchFields' => 'name,amount',
        'iconfile' => 'EXT:ig_crm_time_recording/Resources/Public/Icons/tx_igcrmtimerecording_domain_model_activity.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'tenant_id, active, name, amount, is_internal, internal_purpose, is_default, activity_group, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language, sys_language_uid, l10n_parent, l10n_diffsource, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access, hidden, '],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igcrmtimerecording_domain_model_activity',
                'foreign_table_where' => 'AND {#tx_igcrmtimerecording_domain_model_activity}.{#pid}=###CURRENT_PID### AND {#tx_igcrmtimerecording_domain_model_activity}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],

        'tenant_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.tenant_id',
            'config' => [
                'type' => 'number',
                'size' => 4,
                'default' => null,
                'nullable' => true,
            ]
        ],
        'active' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.active',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 1,
            ]
        ],
        'name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'default' => ''
            ],
        ],
        'amount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.amount',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'nullable' => true,
            ],
        ],
        'is_internal' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.is_internal',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 0,
            ]
        ],
        'internal_purpose' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.internal_purpose',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [
                        'label' => '',
                        'value' => 0,
                    ],
                    [
                        'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.internal_purpose.1',
                        'value' => 1,
                    ],
                    [
                        'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.internal_purpose.2',
                        'value' => 2,
                    ],
                    [
                        'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.internal_purpose.3',
                        'value' => 3,
                    ],
                    [
                        'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.internal_purpose.4',
                        'value' => 4,
                    ],
                    [
                        'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.internal_purpose.5',
                        'value' => 5,
                    ],
                ],
                'default' => 0,
            ]
        ],
        'is_default' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.is_default',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 0,
            ]
        ],
        'activity_group' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_igcrmtimerecording_domain_model_activity.activity_group',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igcrmtimerecording_domain_model_activitygroup',
                'minitems' => 0,
                'maxitems' => 1,
                'nullable' => true,
            ],
            
        ],
    
    ],
];
