const TimeFormat = {
    millisecondsToTime: function (milliseconds) {
	return new Date(milliseconds).toISOString().slice(11, 19);
    },

    timeToSeconds: function(hhmmss) {
	let parts = hhmmss.split(':');
	return (+parts[0]) * 60 * 60 + (+parts[1]) * 60 + (+parts[2]);
    },

    // HH can be over 24 and even over 100
    secondsToHHMMSS: function(seconds) {
	//return new Date(seconds * 1000).toISOString().substr(11, 8);
	// Calculate hours, minutes, and remaining seconds                                                                                
	var hours = Math.floor(seconds / 3600);
	var minutes = Math.floor((seconds % 3600) / 60);
	var remainingSeconds = seconds % 60;

	// Format the values into a string                                                                                                
	var formattedTime =
	    (hours < 10 ? '0' : '') + hours + ':' +
	    (minutes < 10 ? '0' : '') + minutes + ':' +
	    (remainingSeconds < 10 ? '0' : '') + remainingSeconds;
	
	return formattedTime;
    },
    
    formatUTCTime: function(date) {
        let hours = String(date.getUTCHours()).padStart(2, '0');
        let minutes = String(date.getUTCMinutes()).padStart(2, '0');
        let seconds = String(date.getUTCSeconds()).padStart(2, '0');
        return `${hours}:${minutes}:${seconds}`;
    },

    formatTime: function(date) {
        let hours = String(date.getHours()).padStart(2, '0');
        let minutes = String(date.getMinutes()).padStart(2, '0');
        let seconds = String(date.getSeconds()).padStart(2, '0');
        return `${hours}:${minutes}:${seconds}`;
    },

    datePartFromDate: function(date) {
	return date.toISOString().slice(0,10);
    },
    datePartFromString: function(dateString) {
	return dateString.slice(0,10);
    },
    datePartFromStringFormatted: function(dateString) {
	return dateString.slice(8,10) + '.' +  dateString.slice(5,7) + '.' + dateString.slice(0,4);
    },
    timePartFromString: function(dateString) {
	return dateString.slice(11,19);
    },

    timePartFromDate: function(date) {
	return date.toTimeString().split(" ")[0];
    },
    
    formatDateTime: function(date) {
	//return date.toISOString().slice(0, 19).replace('T', ' ');
        let year = date.getFullYear();
        let month = String(date.getMonth() + 1).padStart(2, '0'); // getMonth() is zero-based
        let day = String(date.getDate()).padStart(2, '0');
        let hours = String(date.getHours()).padStart(2, '0');
        let minutes = String(date.getMinutes()).padStart(2, '0');
        let seconds = String(date.getSeconds()).padStart(2, '0');
        return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
    },

    formatAmount: function(amount) {
	return new Intl.NumberFormat('de-CH', {
	    style: 'currency',
	    currency: 'CHF'
	}).format(amount);
    },    
}