<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class Activity extends AbstractEntity
{
    /**
     * tenantId
     */
    protected ?int $tenantId = null;

    /**
     * active
     */
    protected bool $active = true;

    /**
     * name
     */
    protected string $name = '';

    /**
     * amount
     */
    protected ?string $amount = null;

    protected bool $isInternal = false;
    protected int $internalPurpose = 0;

    /**
     * isDefault
     */
    protected bool $isDefault = false;

    /**
     * activityGroup
     *
     * @var ActivityGroup
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    protected $activityGroup = null;

    /**
     * Returns the active
     */
    public function getActive(): bool
    {
        return $this->active;
    }

    /**
     * Sets the active
     */
    public function setActive(bool $active): void
    {
        $this->active = $active;
    }

    /**
     * Returns the boolean state of active
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * Returns the name
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * Sets the name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the amount
     */
    public function getAmount(): string
    {
        return $this->amount;
    }

    /**
     * Sets the amount
     */
    public function setAmount(string $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns the isInternal
     */
    public function getIsInternal(): bool
    {
        return $this->isInternal;
    }

    /**
     * Returns the boolean state of isInternal
     */
    public function isIsInternal(): bool
    {
        return $this->isInternal;
    }

    /**
     * Sets the isInternal
     */
    public function setIsInternal(bool $isInternal): void
    {
        $this->isInternal = $isInternal;
    }

    public function getInternalPurpose(): int
    {
        return $this->internalPurpose;
    }
    public function getInternalPurposeText(): string
    {
        return LocalizationUtility::translate(
            'tx_igcrmtimerecording_domain_model_activity.internal_purpose.' . $this->internalPurpose,
            'ig_crm_time_recording'
        ) ?? '';
    }

    public function setInternalPurpose(int $internalPurpose): void
    {
        $this->internalPurpose = $internalPurpose;
    }


    /**
     * Returns the isDefault
     */
    public function getIsDefault(): bool
    {
        return $this->isDefault;
    }

    /**
     * Sets the isDefault
     */
    public function setIsDefault(bool $isDefault): void
    {
        $this->isDefault = $isDefault;
    }

    /**
     * Returns the boolean state of isDefault
     */
    public function isIsDefault(): bool
    {
        return $this->isDefault;
    }
    
    /**
     * Returns the activityGroup
     */
    public function getActivityGroup(): ActivityGroup
    {
        if ($this->activityGroup instanceof LazyLoadingProxy) {
            $this->activityGroup->_loadRealInstance();
        }
        return $this->activityGroup;
    }

    /**
     * Sets the activityGroup
     */
    public function setActivityGroup(ActivityGroup $activityGroup): void
    {
        $this->activityGroup = $activityGroup;
    }

    /**
     * Returns the tenantId
     */
    public function getTenantId(): ?int
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(?int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }
}
