<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * This file is part of the "IG CRM Time Recording" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024
 */

class Holiday extends AbstractEntity
{
    /**
     * tenantId
     *
     * @var int
     */
    protected $tenantId = 0;

    /**
     * date
     *
     * @var DateTime
     */
    protected $date = null;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * Returns the tenantId
     *
     * @return int
     */
    public function getTenantId()
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }

    /**
     * Returns the date
     *
     * @return DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Sets the date
     */
    public function setDate(DateTime $date): void
    {
        $this->date = $date;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }
}
