const table = document.getElementById('time-table');
const search = JSON.parse(table.getAttribute('data-search'));
const redirectAction = table.getAttribute('data-redirect-action');
var baseUrlEdit = table.getAttribute('data-base-url-edit');
var baseUrlDelete = table.getAttribute('data-base-url-delete');
const extensionPrefix = table.getAttribute('data-extension-prefix');


// Function to remove cHash and everything after it from baseUrl
function removeCHash(url) {
    const cHashIndex = url.indexOf('&cHash=');
    if (cHashIndex !== -1) {
        return url.substring(0, cHashIndex);
    }
    return url;
}
baseUrlEdit = removeCHash(baseUrlEdit);
baseUrlDelete = removeCHash(baseUrlDelete);

function flattenObject(obj, parentKey = '', result = {}) {
    for (const [key, value] of Object.entries(obj)) {
        const newKey = parentKey ? `${parentKey}[${key}]` : key;
        if (typeof value === 'object' && value !== null) {
            flattenObject(value, newKey, result);
        } else {
            result[newKey] = value;
        }
    }
    return result;
}

function createUrl(uid, search, redirectAction, baseUrl, extensionPrefix) {
    const params = new URLSearchParams();
    params.append(`${extensionPrefix}[time]`, uid);
    params.append(`${extensionPrefix}[redirectAction]`, redirectAction);
    console.log(search);
    const flattenedSearch = flattenObject(search, `${extensionPrefix}[search]`);

    for (const [key, value] of Object.entries(flattenedSearch)) {
        params.append(key, value);
    }

    return `${baseUrl}&${params.toString()}`;
}


document.querySelectorAll('.crm-button-ajax').forEach(button => {
    button.addEventListener('click', function(event) {
	event.preventDefault();
        const uid = this.getAttribute('data-uid');
        const action = this.getAttribute('data-action');
	let baseUrl = baseUrlEdit;
	if (action == 'delete') {
	    baseUrl = baseUrlDelete;
	}
        const url = createUrl(uid, search, redirectAction, baseUrl, extensionPrefix);
	//console.log(url,baseUrl);
        window.location.href = url;
    });
});
