<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Model;

use DateTime;
use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;

class Salary
{
    protected ?AddressInterface $contact = null;
    protected Employee $employee;
    protected DateTime $date;
    protected float $commissionAmount = 0;
    protected ?string $commissionText = null;
    protected float $correctionAmount = 0;
    protected ?string $correctionText = null;
    protected float $grossWage = 0; // Bruttolohn
    protected float $netWage = 0; // Nettolohn nach Abzuegen
    protected float $ahvSalary = 0; // AHV Bruttolohn (massgeblicher AHV Lohn)
    protected float $ahvPercent = 0; // AHV %
    protected float $ahvAmount = 0; // AHV amount
    protected float $alvPercent = 0; // ALV %
    protected float $alvAmount = 0; // ALV amount
    protected float $nbuvPercent = 0; // NBUV %
    protected float $nbuvAmount = 0; // NBUV amount
    protected float $bvgAmount = 0; // BVG amount
    protected float $withholdingTaxAmount = 0; // Quellensteuer
    protected int $timeWorked = 0; // time in second worked

    public function getContact(): ?AddressInterface
    {
        return $this->contact;
    }
    public function setContact(?AddressInterface $contact): void
    {
        $this->contact = $contact;
    }

    public function getEmployee(): Employee
    {
        return $this->employee;
    }
    public function setEmployee(Employee $employee): void
    {
        $this->employee = $employee;
    }
    
    public function getDate(): DateTime
    {
        return $this->date;
    }
    public function setDate(DateTime $date): void
    {
        $this->date = $date;
    }
    public function getDateMonth(): int
    {
        return (int)$this->date->format('m');
    }
    public function getIs13(): bool
    {
        // is decmbre
        return $this->date->format('m') === '12';
    }

    public function getGrossWage(): float
    {
        return $this->grossWage;
    }
    public function setGrossWage(float $grossWage): void
    {
        $this->grossWage = $grossWage;
    }

    public function getNetWage(): float
    {
        return $this->netWage;
    }
    public function setNetWage(float $netWage): void
    {
        $this->netWage = $netWage;
    }
    
    public function getSalary13(): float
    {
        return $this->salary13;
    }
    public function setSalary13(float $salary13): void
    {
        $this->salary13 = $salary13;
    }

    /**
     * Returns the commissionAmount
     */
    public function getCommissionAmount(): ?float
    {
        return $this->commissionAmount;
    }

    /**
     * Sets the commissionAmount
     */
    public function setCommissionAmount(?float $commissionAmount): void
    {
        $this->commissionAmount = $commissionAmount;
    }

    /**
     * Returns the commissionText
     */
    public function getCommissionText(): ?string
    {
        return $this->commissionText;
    }
    /**
     * Sets the commissionText
     */
    public function setCommissionText(?string $commissionText): void
    {
        $this->commissionText = $commissionText;
    }
    /**
     * Returns the correctionAmount
     */
    public function getCorrectionAmount(): float
    {
        return $this->correctionAmount;
    }

    /**
     * Sets the correctionAmount
     */
    public function setCorrectionAmount(float $correctionAmount): void
    {
        $this->correctionAmount = $correctionAmount;
    }

    /**
     * Returns the correctionText
     */
    public function getCorrectionText(): ?string
    {
        return $this->correctionText;
    }

    /**
     * Sets the correctionText
     */
    public function setCorrectionText(?string $correctionText): void
    {
        $this->correctionText = $correctionText;
    }

    public function getAhvSalary(): float
    {
        return $this->ahvSalary;
    }

    public function setAhvSalary(float $ahvSalary): void
    {
        $this->ahvSalary = $ahvSalary;
    }

    public function getAhvPercent(): float
    {
        return $this->ahvPercent;
    }

    public function setAhvPercent(float $ahvPercent): void
    {
        $this->ahvPercent = $ahvPercent;
    }

    public function getAhvAmount(): float
    {
        return $this->ahvAmount;
    }

    public function setAhvAmount(float $ahvAmount): void
    {
        $this->ahvAmount = $ahvAmount;
    }

    public function getAlvPercent(): float
    {
        return $this->alvPercent;
    }

    public function setAlvPercent(float $alvPercent): void
    {
        $this->alvPercent = $alvPercent;
    }

    public function getAlvAmount(): float
    {
        return $this->alvAmount;
    }

    public function setAlvAmount(float $alvAmount): void
    {
        $this->alvAmount = $alvAmount;
    }

    public function getNbuvPercent(): float
    {
        return $this->nbuvPercent;
    }

    public function setNbuvPercent(float $nbuvPercent): void
    {
        $this->nbuvPercent = $nbuvPercent;
    }

    public function getNbuvAmount(): float
    {
        return $this->nbuvAmount;
    }

    public function setNbuvAmount(float $nbuvAmount): void
    {
        $this->nbuvAmount = $nbuvAmount;
    }

    public function getBvgAmount(): float
    {
        return $this->bvgAmount;
    }

    public function setBvgAmount(float $bvgAmount): void
    {
        $this->bvgAmount = $bvgAmount;
    }

    public function getWithholdingTaxAmount(): float
    {
        return $this->withholdingTaxAmount;
    }

    public function setWithholdingTaxAmount(float $withholdingTaxAmount): void
    {
        $this->withholdingTaxAmount = $withholdingTaxAmount;
    }
    public function getTimeWorked(): int
    {
        return $this->timeWorked;
    }

    public function setTimeWorked(int $timeWorked): void
    {
        $this->timeWorked = $timeWorked;
    }
}
