<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Activities
 */
class ActivityRepository extends Repository
{
    protected $defaultOrderings = [
        'name' => QueryInterface::ORDER_ASCENDING,
    ];

    public function getDefault()
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('isDefault', 1)];
        $query->matching($query->logicalAnd(...$constraints));
        return $query->execute()
->getFirst();
    }
    public function findBySearch(array $search = [])
    {
        $query = $this->createQuery();
        $constrains = [];
        if (isset($search['uid']) && $search['uid'] !== '') {
            $constrains[] = $query->equals('uid', (int)$search['uid']);
        }
        if ($search['isInternal'] ?? false) {
            $constrains[] = $query->equals('isInternal', (int)$search['isInternal']);
        }
        if ($search['internalPurpose'] ?? false) {
            $constrains[] = $query->equals('internalPurpose', (int)$search['internalPurpose']);
        }
        if ($search['hasInternalPurpose'] ?? false) {
            $constrains[] = $query->greaterThan('internalPurpose', 0);
        }
        if ($search['internalPurposeIn'] ?? false && !empty(\SEARCH['internalPurposeIn'])) {
            $constrains[] = $query->in('internalPurpose', $search['internalPurposeIn']);
        }
        $query->matching(...$constrains);
        return $query->execute();
    }
    public function findOneRawByUid(int $uid): array
    {
        $query = $this->createQuery();
        $query->matching($query->equals('uid', $uid));
        return $query->execute(true)[0] ?? [];
    }
}
