<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Repository;
use TYPO3\CMS\Core\Database\Connection;

use Internetgalerie\IgCrmTimeRecording\Utility\PersonUtility;
use PDO;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\QueryResult;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Employees
 */
class EmployeeRepository extends Repository
{
    protected static string $tablename = 'tx_igcrmtimerecording_domain_model_employee';
    protected static string $tablenameFeUsers = 'fe_users';
    protected static ?PersonUtility $personUtility = null;


    protected $defaultOrderings = [
        'active' => QueryInterface::ORDER_DESCENDING,
        'lastName' => QueryInterface::ORDER_ASCENDING,
        'firstName' => QueryInterface::ORDER_ASCENDING,
        //'frontendUser.lastName' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
        //'frontendUser.firstName' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
    ];




    public static function getRawByUid(int $uid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(self::$tablename);
        $employee = $queryBuilder
                  ->select('uid', 'frontend_user', 'contact_id', 'short_name', 'last_name', 'first_name')
                  ->from(self::$tablename)
                  ->where(
                      $queryBuilder->expr()
->eq('uid', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT)),
                  )
                  ->executeQuery()
                  ->fetchAssociative();
        $contactId = (int)($employee['contact_id'] ?? 0);
        if ($contactId) {
            $contact = static::getPersonUtility()->getContact($contactId);
            $employee['name'] = $contact->getName();
            return $employee;
        }
        $frontendUserUid = (int)($employee['frontend_user'] ?? 0);
        /*
        if ($frontendUserUid) {
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(self::$tablenameFeUsers);
            $user = $queryBuilder
                  ->select('uid', 'first_name', 'last_name', 'username')
                  ->from(self::$tablenameFeUsers)
                  ->where(
                      $queryBuilder->expr()->eq(
                          'uid',
                          $queryBuilder->createNamedParameter($frontendUserUid, \Connection::PARAM_INT)
                      ),
                  )
                  ->executeQuery()
                  ->fetchAssociative();

            $employee['name'] = $user['last_name'] . ' ' . $user['first_name'];
            return $employee;
        }
        */
        $employee['lastName'] = $employee['last_name'];
        $employee['firstName'] = $employee['first_name'];
        $employee['shortName'] = $employee['short_name'];
        $employee['name'] = $employee['lastName'] . ' ' . $employee['firstName'];
        unset($employee['last_name']);
        unset($employee['first_name']);
        unset($employee['short_name']);
        return $employee;
    }

    public static function getPersonUtility(): PersonUtility
    {
        if (static::$personUtility === null) {
            static::$personUtility = GeneralUtility::makeInstance(PersonUtility::class);
        }
        return static::$personUtility;
    }

    public function findActive(): QueryResult
    {
        $query = $this->createQuery();
        $query->matching($query->equals('active', true));
        return $query->execute();
    }
    public function findActiveWithYear(int $year): QueryResult
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalOr(
                $query->equals('entryDate', null),
                $query->lessThanOrEqual('entryDate', $year . '-01-01'),
            ),
            $query->logicalOr(
                $query->equals('exitDate', null),
                $query->greaterThanOrEqual('exitDate', $year . '-12-31'),
            ),
        );
        return $query->execute();
    }
    public function findBySearch(array $search = [], array $orderBy = []): QueryResult
    {
        $query = $this->createQuery();
        $constraints = [];

        if ($search['keywords'] ?? false) {
            $keywordsArray = GeneralUtility::trimExplode(' ', $search['keywords'], true);
            if (!empty($keywordsArray)) {
                foreach ($keywordsArray as $keyword) {
                    $constraints[] = $query->logicalOr(
                        $query->like('lastName', '%' . $keyword . '%'),
                        $query->like('firstName', '%' . $keyword . '%')
                        //$query->like('frontendUser.lastName', '%' . $keyword . '%'),
                        //$query->like('frontendUser.firstName', '%' . $keyword . '%')
                    );
                }
            }
        }
        if (isset($search['active']) && $search['active'] !== '') {
            $constraints[] = $query->equals('active', $search['active']);
        }

        if (!empty($constraints)) {
            $query->matching($query->logicalAnd(...$constraints));
        }
        return $query->execute();
    }
}
