<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Utility;

class DateUtility
{
    /**
     * get time HH:MM:SS (with leading zero)
     */
    public static function secondsToHHMMSS(int $seconds): string
    {
        $s = $seconds % 60;
        $m = ($seconds - $s) / 60 % 60;
        $h = (int)($seconds / 3600);
        return sprintf('%02d:%02d:%02d', $h, $m, $s);
    }

    /**
     * get time H:MM:SS (can be 4:00:00 without leading zero)
     */
    public static function secondsToHMMSS(int $seconds): string
    {
        $s = $seconds % 60;
        $m = ($seconds - $s) / 60 % 60;
        $h = (int)($seconds / 3600);
        return sprintf('%d:%02d:%02d', $h, $m, $s);
    }
    /**
     * convert HH:MM:SS to seconds
     */
    public static function timeToSeconds(string $time): int
    {
        [$hours, $minutes, $seconds] = explode(':', $time);
        return ($hours * 3600) + ($minutes * 60) + $seconds;
    }

    public static function getDateFormat()
    {
        return 'd.m.Y';
    }
    public static function getTimeFormat()
    {
        return 'H:i:s';
    }
    public static function getDateTimeFormat()
    {
        return 'd.m.Y H:i:s';
    }
}
