<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Model;

use DateTime;
use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgCrmTimeRecording\Utility\PersonUtility;
use Internetgalerie\IgDatapoolFe\Domain\Repository\CountryRepository;
use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;

class Employee extends AbstractEntity implements AddressInterface
{
    /**
     * FrontendUser
     */
    protected ?FrontendUser $frontendUser = null;

    protected ?int $contactId = null;
    protected ?AddressInterface $contact = null;

    protected bool $active = false;
    protected string $lastName = '';
    protected string $firstName = '';
    protected string $shortName = '';
    protected string $street = '';
    protected string $streetNr = '';
    protected string $zip = '';
    protected string $city = '';
    protected string $countryIsoCode = '';
    protected string $email = '';
    protected string $phone = '';
    protected string $mobile = '';
    protected string $zpv = '';
    protected ?DateTime $birthday = null;
    protected string $businessPhone = '';
    protected string $businessPhoneUrl = '';
    protected string $businessEmail = '';
    protected string $jobTitle = '';
    protected string $gender = '';
    protected string $title = '';
    protected string $placeOfOrigin = '';
    protected string $signature = '';
    protected ?float $salary = null;

    protected bool $freeTransport = false;

    protected int $timeCarryover = 0;
    protected float $holidayCarryover = 0.0;
    protected int $employmentInPercent = 0;
    protected int $holidayDaysInYear = 0;

    protected ?DateTime $entryDate = null;
    protected ?DateTime $exitDate = null;

    protected ?float $bvg = null;
    protected ?float $quellensteuer = null;
    protected bool $noNbuv = false;
    protected bool $salary13Active = false;
    protected ?float $salary13Extra = null;
    protected ?float $commissionAmount = null;
    protected string $commissionText = '';
    protected ?float $correctionAmount = null;
    protected string $correctionText = '';

    protected int $numberOfChildren = 0;
    protected bool $ahvMandatory = false;
    protected ?float $hourlyWage = null;
    protected ?int $salary13Month = null;
    protected string $bankAccount = '';

    protected ?PersonUtility $personUtility = null;
    protected ?QueryResultInterface $country = null;

    public function getNumber()
    {
        return $this->uid;
    }
    public function getIsOrganisation()
    {
        return false;
    }
    public function getOrganisationName()
    {
        return '';
    }

    public function getPersonUtility(): PersonUtility
    {
        if ($this->personUtility === null) {
            $this->personUtility = GeneralUtility::makeInstance(PersonUtility::class);
        }
        return $this->personUtility;
    }
    
    public function getFrontendUserUid(): ?int
    {
        return $this->getFrontendUser()?->getUid();
    }
    /**
     * Returns the frontendUser
     */
    public function getFrontendUser(): ?FrontendUser
    {
        if ($this->frontendUser instanceof LazyLoadingProxy) {
            $this->frontendUser = $this->frontendUser->_loadRealInstance();
        }
        return $this->frontendUser;
    }
    public function getContactId()
    {
        return $this->contactId;
    }
    public function getContact(): ?AddressInterface
    {
        if ($this->contact === null && $this->contactId) {
            $this->contact = $this->getPersonUtility()
                           ->getContact($this->contactId);
        }
        return $this->contact;
    }
    
    public function setContactId(?int $contactId): void
    {
        $this->contactId = $contactId;
    }

    
    /**
     * Sets the frontendUser
     */
    public function setFrontendUser(FrontendUser $frontendUser): void
    {
        $this->frontendUser = $frontendUser;
    }

    /*
      public function getAddress()
      {
      $contact = $this->getContact();
      return $contact ? : $this->getFrontendUser();
      }
    */
    // Getter and Setter for lastName
    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    // Getter and Setter for firstName
    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }

    // Getter and Setter for street
    public function getStreet(): string
    {
        return $this->street;
    }

    public function setStreet(string $street): void
    {
        $this->street = $street;
    }

    // Getter and Setter for streetNr
    public function getStreetNr(): string
    {
        return $this->streetNr;
    }

    public function setStreetNr(string $streetNr): void
    {
        $this->streetNr = $streetNr;
    }
    public function getAddress()
    {
        return $this->street . ($this->streetNr ? ' ' . $this->streetNr : '');
    }
    public function getAddress2()
    {
        return '';
    }
    public function getAddress3()
    {
        return '';
    }
    public function getAddon()
    {
        return '';
    }
    public function getPoboxText()
    {
        return '';
    }
    public function getType()
    {
        return 'Person';
    }

    
    // Getter and Setter for zip
    public function getZip(): string
    {
        return $this->zip;
    }

    public function setZip(string $zip): void
    {
        $this->zip = $zip;
    }

    // Getter and Setter for city
    public function getCity(): string
    {
        return $this->city;
    }

    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    // Getter and Setter for email
    public function getEmail(): string
    {
        return $this->email;
    }

    public function setEmail(string $email): void
    {
        $this->email = $email;
    }
    public function getPhone(): string
    {
        return $this->phone;
    }
    public function setPhone(string $phone): void
    {
        $this->phone = $phone;
    }
    public function getMobile(): string
    {
        return $this->mobile;
    }
    public function setMobile(string $mobile): void
    {
        $this->mobile = $mobile;
    }
    
    // Getter and Setter for zpv
    public function getZpv(): string
    {
        return $this->zpv;
    }

    public function setZpv(string $zpv): void
    {
        $this->zpv = $zpv;
    }

    // Getter and Setter for birthday
    public function getBirthday(): ?DateTime
    {
        return $this->birthday;
    }

    public function setBirthday(?DateTime $birthday): void
    {
        $this->birthday = $birthday;
    }

    // Getter and Setter for businessPhone
    public function getBusinessPhone(): string
    {
        return $this->businessPhone;
    }

    public function setBusinessPhone(string $businessPhone): void
    {
        $this->businessPhone = $businessPhone;
    }

    // Getter and Setter for businessPhoneUrl
    public function getBusinessPhoneUrl(): string
    {
        return $this->businessPhoneUrl;
    }

    public function setBusinessPhoneUrl(string $businessPhoneUrl): void
    {
        $this->businessPhoneUrl = $businessPhoneUrl;
    }

    // Getter and Setter for businessEmail
    public function getBusinessEmail(): string
    {
        return $this->businessEmail;
    }

    public function setBusinessEmail(string $businessEmail): void
    {
        $this->businessEmail = $businessEmail;
    }

    // Getter and Setter for jobTitle
    public function getJobTitle(): string
    {
        return $this->jobTitle;
    }

    public function setJobTitle(string $jobTitle): void
    {
        $this->jobTitle = $jobTitle;
    }

    // Getter and Setter for gender
    public function getGender(): string
    {
        return $this->gender;
    }

    public function setGender(string $gender): void
    {
        $this->gender = $gender;
    }

    // Getter and Setter for title
    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): void
    {
        $this->title = $title;
    }
    public function getName(): string
    {
        if ($this->lastName) {
            return $this->lastName . ' ' . $this->firstName;
        }
        $contact = $this->getContact();
        if ($contact) {
            return $contact->getLastName() . ' ' . $contact->getFirstName();
        }
        $user = $this->getFrontendUser();
        return $user ? trim($user->getLastName() . ' ' . $user->getFirstName()) : '';
    }
    public function getUsername(): string
    {
        return $this->getFrontendUser()?->getUsername() ?? '';
    }

    public function getLabel(): string
    {
        $name = trim($this->getName());
        return $name ?: $this->getUsername();
    }


    public function getCountryIsoCode(): string
    {
        return $this->countryIsoCode;
    }
    public function getCountryPostalCode(): string
    {
        if ($this->countryIsoCode == 'LI') {
            return 'FL';
        }
        return $this->countryIsoCode ?: 'CH';
    }
    public function getCountry()
    {
        if ($this->country === null && $this->countryIsoCode) {
            $countryRepository = GeneralUtility::makeInstance(CountryRepository::class);
            $this->country = $countryRepository->findOneByCnIso_2($this->countryIsoCode);
        }
        return $this->country;
    }

    
    public function getInvoiceEmail()
    {
        return $this->email;
    }
    public function setCountryIsoCode(string $countryIsoCode): void
    {
        $this->countryIsoCode = $countryIsoCode;
    }
    public function getLanguageCode()
    {
        return $this->countryIsoCode;
    }
    public function getShortName(): string
    {
        return $this->shortName;
    }
    public function setShortName(string $shortName): void
    {
        $this->shortName = $shortName;
    }

    public function getPlaceOfOrigin(): string
    {
        return $this->placeOfOrigin;
    }
    public function setPlaceOfOrigin(string $placeOfOrigin): void
    {
        $this->placeOfOrigin = $placeOfOrigin;
    }

    public function getSignature(): string
    {
        return $this->signature;
    }

    public function setSignature(string $signature): void
    {
        $this->signature = $signature;
    }

    
    /**
     * Returns the salary
     */
    public function getSalary(): ?float
    {
        return $this->salary;
    }

    /**
     * Sets the salary
     */
    public function setSalary(?float $salary): void
    {
        $this->salary = $salary;
    }

    public function getFreeTransport(): ?bool
    {
        return $this->freeTransport;
    }

    /**
     * Sets the freeTransport
     */
    public function setFreeTransport(?bool $freeTransport): void
    {
        $this->freeTransport = $freeTransport;
    }

    /**
     * Returns the boolean state of freeTransport
     */
    public function isFreeTransport(): bool
    {
        return $this->freeTransport;
    }


    
    /**
     * Returns the timeCarryover
     *
     * @return int
     */
    public function getTimeCarryover()
    {
        return $this->timeCarryover;
    }

    /**
     * Sets the timeCarryover
     */
    public function setTimeCarryover(int $timeCarryover): void
    {
        $this->timeCarryover = $timeCarryover;
    }

    /**
     * Returns the holidayCarryover
     *
     * @return float
     */
    public function getHolidayCarryover()
    {
        return $this->holidayCarryover;
    }

    /**
     * Sets the holidayCarryover
     */
    public function setHolidayCarryover(float $holidayCarryover): void
    {
        $this->holidayCarryover = $holidayCarryover;
    }

    /**
     * Returns the employmentInPercent
     *
     * @return int
     */
    public function getEmploymentInPercent()
    {
        return $this->employmentInPercent;
    }

    /**
     * Sets the employmentInPercent
     */
    public function setEmploymentInPercent(int $employmentInPercent): void
    {
        $this->employmentInPercent = $employmentInPercent;
    }

    /**
     * Returns the holidayDaysInYear
     *
     * @return int
     */
    public function getHolidayDaysInYear()
    {
        return $this->holidayDaysInYear;
    }
    public function getTotalHolidayDaysInYear()
    {
        return $this->holidayDaysInYear + $this->holidayCarryover;
    }

    /**
     * Sets the holidayDaysInYear
     */
    public function setHolidayDaysInYear(int $holidayDaysInYear): void
    {
        $this->holidayDaysInYear = $holidayDaysInYear;
    }

    /**
     * Returns the active
     */
    public function getActive(): ?bool
    {
        return $this->active;
    }

    /**
     * Sets the active
     */
    public function setActive(?bool $active): void
    {
        $this->active = $active;
    }

    /**
     * Returns the boolean state of active
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * Returns the entryDate
     */
    public function getEntryDate(): ?DateTime
    {
        return $this->entryDate;
    }

    /**
     * Sets the entryDate
     */
    public function setEntryDate(?DateTime $entryDate): void
    {
        $this->entryDate = $entryDate;
    }

    /**
     * Returns the exitDate
     */
    public function getExitDate(): ?DateTime
    {
        return $this->exitDate;
    }

    /**
     * Sets the exitDate
     */
    public function setExitDate(?DateTime $exitDate): void
    {
        $this->exitDate = $exitDate;
    }

    /**
     * Returns the bvg
     */
    public function getBvg(): ?float
    {
        return $this->bvg;
    }

    /**
     * Sets the bvg
     */
    public function setBvg(?float $bvg): void
    {
        $this->bvg = $bvg;
    }

    /**
     * Returns the quellensteuer
     */
    public function getQuellensteuer(): ?float
    {
        return $this->quellensteuer;
    }

    /**
     * Sets the quellensteuer
     */
    public function setQuellensteuer(?float $quellensteuer): void
    {
        $this->quellensteuer = $quellensteuer;
    }

    /**
     * Returns the noNbuv
     */
    public function getNoNbuv(): ?bool
    {
        return $this->noNbuv;
    }

    /**
     * Sets the noNbuv
     */
    public function setNoNbuv(?bool $noNbuv): void
    {
        $this->noNbuv = $noNbuv;
    }

    /**
     * Returns the boolean state of noNbuv
     */
    public function isNoNbuv(): ?bool
    {
        return $this->noNbuv;
    }

    /**
     * Returns the salary13Active
     */
    public function getSalary13Active(): ?bool
    {
        return $this->salary13Active;
    }

    /**
     * Sets the salary13Active
     */
    public function setSalary13Active(?bool $salary13Active): void
    {
        $this->salary13Active = $salary13Active;
    }

    /**
     * Returns the boolean state of salary13Active
     */
    public function isSalary13Active(): ?bool
    {
        return $this->salary13Active;
    }

    /**
     * Returns the salary13Extra
     */
    public function getSalary13Extra(): ?float
    {
        return $this->salary13Extra;
    }

    /**
     * Sets the salary13Extra
     */
    public function setSalary13Extra(?float $salary13Extra): void
    {
        $this->salary13Extra = $salary13Extra;
    }

    /**
     * Returns the commissionAmount
     */
    public function getCommissionAmount(): ?float
    {
        return $this->commissionAmount;
    }

    /**
     * Sets the commissionAmount
     */
    public function setCommissionAmount(?float $commissionAmount): void
    {
        $this->commissionAmount = $commissionAmount;
    }

    /**
     * Returns the commissionText
     */
    public function getCommissionText(): ?string
    {
        return $this->commissionText;
    }

    /**
     * Sets the commissionText
     */
    public function setCommissionText(?string $commissionText): void
    {
        $this->commissionText = $commissionText;
    }

    /**
     * Returns the correctionAmount
     */
    public function getCorrectionAmount(): ?float
    {
        return $this->correctionAmount;
    }

    /**
     * Sets the correctionAmount
     */
    public function setCorrectionAmount(?float $correctionAmount): void
    {
        $this->correctionAmount = $correctionAmount;
    }

    /**
     * Returns the correctionText
     */
    public function getCorrectionText(): ?string
    {
        return $this->correctionText;
    }

    /**
     * Sets the correctionText
     */
    public function setCorrectionText(?string $correctionText): void
    {
        $this->correctionText = $correctionText;
    }

    /**
     * Returns the numberOfChildren
     */
    public function getNumberOfChildren(): int
    {
        return $this->numberOfChildren;
    }

    /**
     * Sets the numberOfChildren
     */
    public function setNumberOfChildren(int $numberOfChildren): void
    {
        $this->numberOfChildren = $numberOfChildren;
    }

    /**
     * Returns the ahvMandatory
     */
    public function getAhvMandatory(): ?bool
    {
        return $this->ahvMandatory;
    }

    /**
     * Sets the ahvMandatory
     */
    public function setAhvMandatory(?bool $ahvMandatory): void
    {
        $this->ahvMandatory = $ahvMandatory;
    }

    /**
     * Returns the boolean state of ahvMandatory
     */
    public function isAhvMandatory(): ?bool
    {
        return $this->ahvMandatory;
    }

    /**
     * Returns the hourlyWage
     */
    public function getHourlyWage(): ?float
    {
        return $this->hourlyWage;
    }

    /**
     * Sets the hourlyWage
     */
    public function setHourlyWage(?float $hourlyWage): void
    {
        $this->hourlyWage = $hourlyWage;
    }

    /**
     * Returns the salary13Month
     */
    public function getSalary13Month(): ?int
    {
        return $this->salary13Month;
    }

    /**
     * Sets the salary13Month
     */
    public function setSalary13Month(?int $salary13Month): void
    {
        $this->salary13Month = $salary13Month;
    }

    /**
     * Returns the bankAccount
     */
    public function getBankAccount(): ?string
    {
        return $this->bankAccount;
    }

    /**
     * Sets the bankAccount
     */
    public function setBankAccount(?string $bankAccount): void
    {
        $this->bankAccount = $bankAccount;
    }
}
