<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Holiday extends AbstractEntity
{
    protected int $tenantId = 0;
    protected ?DateTime $date = null;
    protected string $name = '';

    /**
     * Returns the tenantId
     */
    public function getTenantId(): int
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }

    /**
     * Returns the date
     */
    public function getDate(): ?DateTime
    {
        return $this->date;
    }

    /**
     * Sets the date
     */
    public function setDate(DateTime $date): void
    {
        $this->date = $date;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * Sets the name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }
}
