<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Domain\Model;

use DateInterval;
use DateTime;
use Internetgalerie\IgAcl\Domain\Model\AclOwnerInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgCrmTimeRecording\Utility\DateUtility;
use Internetgalerie\IgCrmTimeRecording\Utility\PersonUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;

class Time extends AbstractEntity implements AclOwnerInterface
{
    /**
     * tenantId
     */
    protected ?int $tenantId = null;

    /**
     * employeeId
     */
    protected ?int $employeeId = null;

    /**
     * startDate
     */
    protected ?DateTime $startDate = null;

    /**
     * duration
     */
    protected ?int $duration = null;

    /**
     * description
     */
    protected ?string $description = null;

    /**
     * contactId
     */
    protected ?int $contactId = null;

    /**
     * offerId
     */
    protected ?int $offerId = null;

    /**
     * workflowId
     */
    protected ?int $workflowId = null;

    /**
     * isChanged
     */
    protected bool $isChanged = false;

    /**
     * origStartDate
     */
    protected ?DateTime $origStartDate = null;

    /**
     * origDuration
     */
    protected ?int $origDuration = null;

    /**
     * activity
     *
     * @var ?Activity
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    protected $activity = null;

    /**
     * employee
     */
    protected ?AbstractEntity $employee = null;

    /**
     * isError
     */
    protected bool $isError = false;

    protected ?PersonUtility $personUtility = null;
    
    /**
     * Returns the employeeId
     */
    public function getEmployeeId(): ?int
    {
        return $this->employeeId;
    }

    public function getAclOwner(): int
    {
        $employee = $this->getEmployee();
        $frontendUserUid = $employee->getFrontendUserUid();
        return $frontendUserUid;
    }

    
    public function getPersonUtility(): PersonUtility
    {
        if ($this->personUtility === null) {
            $this->personUtility = GeneralUtility::makeInstance(PersonUtility::class);
        }
        return $this->personUtility;
    }
    
    public function getEmployee(): ?Employee
    {
        if ($this->employee === null) {
            if ($this->employeeId) {
                $this->employee = $this->getPersonUtility()
->getEmployeeByUid($this->employeeId);
            } else {
                $this->employee = null;
            }
        }
        return $this->employee;
    }

    /**
     * Sets the employeeId
     */
    public function setEmployeeId(int $employeeId): void
    {
        $this->employeeId = $employeeId;
    }

    /**
     * Returns the startDate
     */
    public function getStartDate(): DateTime
    {
        return $this->startDate;
    }

    /**
     * Sets the startDate
     */
    public function setStartDate(DateTime $startDate): void
    {
        $this->startDate = $startDate;
    }
    public function getEndDate(): DateTime
    {
        $endDate = clone $this->startDate;
        $endDate->add(new DateInterval('PT' . $this->duration . 'S'));
        return $endDate;
    }

    public function getEndTime(): string
    {
        return $this->getEndDate()
                    ->format('H:i:s');
    }

    /**
     * Returns the duration
     */
    public function getDuration(): int
    {
        return $this->duration;
    }
    
    public function getDurationTime(): string
    {
        return DateUtility::secondsToHMMSS($this->duration);
    }

    public function getDurationTimeWithLeadingZero(): string
    {
        return DateUtility::secondsToHHMMSS($this->duration);
    }
    public function getDurationInDay(): float
    {
        return $this->duration / $this->getPersonUtility()
->getWorkingDayInSeconds();
    }

    /**
     * Sets the duration
     */
    public function setDuration(int $duration): void
    {
        $this->duration = $duration;
    }

    /**
     * Returns the description
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * Sets the description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * Returns the contactId
     */
    public function getContactId(): ?int
    {
        return $this->contactId;
    }

    public function getContact(): ?AddressInterface
    {
        if ($this->contact === null && $this->contactId) {
            $this->contact = $this->getPersonUtility()
                                  ->findByUid($this->contactId);
        }
        return $this->contact;
    }

    /**
     * Sets the contactId
     */
    public function setContactId(int $contactId): void
    {
        $this->contactId = $contactId;
    }

    /**
     * Returns the offerId
     */
    public function getOfferId(): ?int
    {
        return $this->offerId;
    }

    /**
     * Sets the offerId
     */
    public function setOfferId(?int $offerId): void
    {
        $this->offerId = $offerId;
    }

    /**
     * Returns the workflowId
     */
    public function getWorkflowId(): ?int
    {
        return $this->workflowId;
    }

    /**
     * Sets the workflowId
     */
    public function setWorkflowId(?int $workflowId): void
    {
        $this->workflowId = $workflowId;
    }

    /**
     * Returns the isChanged
     */
    public function getIsChanged(): bool
    {
        return $this->isChanged;
    }

    /**
     * Sets the isChanged
     */
    public function setIsChanged(bool $isChanged): void
    {
        $this->isChanged = $isChanged;
    }

    /**
     * Returns the boolean state of isChanged
     *
     * @return bool
     */
    public function isIsChanged()
    {
        return $this->isChanged;
    }

    /**
     * Returns the origStartDate
     *
     * @return DateTime
     */
    public function getOrigStartDate()
    {
        return $this->origStartDate;
    }

    /**
     * Sets the origStartDate
     */
    public function setOrigStartDate(?DateTime $origStartDate): void
    {
        $this->origStartDate = $origStartDate;
    }

    /**
     * Returns the origDuration
     *
     * @return int
     */
    public function getOrigDuration()
    {
        return $this->origDuration;
    }

    /**
     * Sets the origDuration
     */
    public function setOrigDuration(int $origDuration): void
    {
        $this->origDuration = $origDuration;
    }

    /**
     * Returns the activity
     */
    public function getActivity(): ?Activity
    {
        if ($this->activity instanceof LazyLoadingProxy) {
            $this->activity->_loadRealInstance();
        }
        return $this->activity;
    }
    public function getActivityId()
    {
        return $this->getActivity === null ? null : $this->activity->getUid();
    }

    /**
     * Sets the activity
     */
    public function setActivity(?Activity $activity): void
    {
        $this->activity = $activity;
    }

    /**
     * Returns the tenantId
     */
    public function getTenantId(): ?int
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(?int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }



    /**
     * Returns the isError
     */
    public function getIsError(): bool
    {
        return $this->isError;
    }

    /**
     * Sets the isError
     */
    public function setIsError(bool $isError): void
    {
        $this->isError = $isError;
    }
}
