<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTimeRecording\Utility;

use DateTime;
use Internetgalerie\IgCrmTimeRecording\Domain\Model\Employee;
use Internetgalerie\IgCrmTimeRecording\Domain\Model\Salary;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class SalaryUtility implements SingletonInterface
{
    public function getSalaries(array $employees, $date)
    {
        $salaries = [];
        foreach ($employees as $employee) {
            $salaries [] = $this->getSalary($employee, $date);
        }
        return $salaries;
    }
    public function getSalary(Employee $employee, $date)
    {
        $salary = GeneralUtility::makeInstance(Salary::class);
        $salary->setEmployee($employee);
        $salary->setContact($employee->getContact());
        $dateTime = new DateTime($date ?: 'first day of last month');
        $salary->setDate($dateTime);

        /*
          <%VAR Integer personGeburtsjahr= int($'ma_geburtsdatum') %>
          <%VAR Integer personAlter= int(date('Y')) - $XpersonGeburtsjahr %>
          <%VAR Boolean ahvBeitragspflicht = ( $XpersonAlter>17 ) %>
          <%Xdate.Subtract(0,0,5)%>
          <%VAR Double ma_eintritts_faktor = 1 %>
          <%VAR Integer zeit=0 %>
          <%VAR Double ma_std_lohn=0 %>
          <%IF $'ma_eintritt_date'!=$'anfangmonat' && $Fma_eintritt_date==$'anfangmonat'{<%Xma_eintritts_faktor=0.5%>}%>
          <%IF $'ma_austritt_date'[8..9]=='20' {
          <%Xma_eintritts_faktor= 20/31 %>
          }%>
          <%VAR Double ma_lohn = double($'ma_lohn')*double($'ma_anstellung')/100 * $Xma_eintritts_faktor %>
          }%>
          <%Xma_lohn= double($'ma_std_lohn')*double($Xzeit)/3600 %>
          }%>
          <%VAR Double ma_bvg = double($'ma_bvg') * $Xma_eintritts_faktor %>
          <%VAR Double ma_quellensteuer = double($'ma_quellensteuer') %>
          <%VAR Double ma_korrektur = double($'ma_korrektur') %>
          <%IF ($Xis13 && $'ma_13lohn_aktiv'!='f') || $'ma_13lohn_monate'=="-1"  {
          <%LOOPSQL ("SELECT sum(lz_lohn*lz_anstellung/100) AS total_lz_lohn FROM lohn_zahlungen WHERE lz_monat<>12 AND lz_monat<>"+ date('m')+" AND date_part('YEAR',lz_date)="+ date('Y')+" AND lz_ma_id="+sqlint($'ma_id')  ) {<%VAR Double ma_13lo\
          hn = double($Ptotal_lz_lohn) %>}%>
          <%Xma_13lohn += $Xma_lohn %>
          <%Xma_13lohn /= 12 %>
          } else {
          <%VAR Double ma_13lohn = $Xma_lohn/12*double($'ma_13lohn_monate') %>
          }%>
          <%VAR Double ma_provision = double($'ma_provision') %>
          <%VAR Double ma_kinder_anzahl = double($'ma_kinder_anzahl') %>
          <%VAR Double ma_kinder_ansatz = double($XkinderzulageProKind) %>
          <%VAR Double ma_kinder_total = $Xma_kinder_anzahl*$Xma_kinder_ansatz %>
          <%Xma_13lohn=round( $Xma_13lohn, 0.05) %>
          <%IF double($'ma_extra_13lohn')>0 {
          <%Xma_13lohn=round( double($'ma_extra_13lohn'), 0.05) %>
          }%>
          DONE ab hier
          <%VAR Double ma_bruttolohn_ahv = $X'ma_lohn'+$Xma_13lohn+$Xma_provision %>
          <%VAR Double ma_bruttolohn = $Xma_bruttolohn_ahv + $Xma_kinder_total %>
          <%IF $XahvBeitragspflicht {
          <%VAR Double ahv = $Xdefault_ahv %>// bis 1.1.2020 5.125 bis 1.1.2016 5.15
          <%VAR Double alv = $Xdefault_alv %>
          <%VAR Double nbuv = $Xdefault_nbuv %>
          } else {
          <%VAR Double ahv = 0.0 %>
          <%VAR Double alv = 0.0 %>
          <%VAR Double nbuv = 0.0 %>
          }%>
          <%VAR Double ma_ahv= round( $Xma_bruttolohn_ahv * $Xahv / 100, 0.05) %>
          <%VAR Double ma_alv= round( $Xma_bruttolohn_ahv * $Xalv / 100, 0.05) %>
          <%VAR Double ma_nbuv= round( $Xma_bruttolohn_ahv * $Xnbuv / 100, 0.05) %>
          <%IF $'ma_no_nbuv'=='t' {<%Xma_nbuv= 0 %>}%>
          <%VAR Double ma_nettolohn = $Xma_bruttolohn-$Xma_ahv - $Xma_alv - $Xma_nbuv - $Xma_bvg - $Xma_quellensteuer + $Xma_korrektur %>
         */
        $salary100 = $employee->getSalary() ?? 0;
        $employmentInPercent = $employee->getEmploymentInPercent() ?? 0;
        $grossWage = $salary100 * $employmentInPercent / 100;

        $hourlyWage = $employee->getHourlyWage();
        // @todo
        $timeWorked = 7200;
        $salary->setTimeWorked($timeWorked);
        if ($timeWorked > 0 && $hourlyWage !== null && $hourlyWage > 0) {
            $grossWage += $hourlyWage * $timeWorked / 3600;
        }
        $salary13 = 0;
        $commissionAmount = $employee->getCommissionAmount() ?? 0;

        // @todo
        $childAllowanceQuantity = $employee->getNumberOfChildren();
        $childAllowanceRate = 0;
        $childAllowanceAmount = $childAllowanceRate * $childAllowanceQuantity;

        // @todo
        $contact = $employee->getContact();
        $ageInYear = $contact ? $contact->getAgeInYear() : 0;
        $ahvContributionObligation = $ageInYear > 17 || $ageInYear == 0;

        $ahvSalary = $grossWage + $salary13 + $commissionAmount;
        $salary->setAhvSalary($ahvSalary);
        if ($ahvContributionObligation) {
            $ahv = 5.30;
            $alv = 1.10;
            $nbuv = 1.19;
        } else {
            $ahv = 0.0;
            $alv = 0.0;
            $nbuv = 0.0;
        }

        $ahvAmount = $ahvSalary * $ahv / 100;
        $salary->setAhvPercent($ahv);
        $salary->setAhvAmount($ahvAmount);
        $alvAmount = $ahvSalary * $alv / 100;
        $salary->setAlvPercent($alv);
        $salary->setAlvAmount($alvAmount);
        if ($employee->getNoNbuv()) {
            $nbuvAmount = 0;
        } else {
            $nbuvAmount = $ahvSalary * $nbuv / 100;
        }
        $salary->setNbuvPercent($nbuv);
        $salary->setNbuvAmount($nbuvAmount);
        $bvgAmount = $employee->getBvg() / 12;
        $salary->setBvgAmount($bvgAmount);
        $withholdingTaxAmount = (float)$employee->getQuellensteuer();
        $salary->setWithholdingTaxAmount($withholdingTaxAmount);

        $correctionAmount = (float)$employee->getCorrectionAmount();
        $salary->setCorrectionAmount($correctionAmount);
        $salary->setCorrectionText($employee->getCorrectionText());

        $netWage = $grossWage - $ahvAmount - $alvAmount - $nbuvAmount - $bvgAmount - $withholdingTaxAmount + $correctionAmount;
        $salary->setCommissionAmount($employee->getCommissionAmount());
        $salary->setCommissionText($employee->getCommissionText());
        $salary->setSalary13($salary13);
        $salary->setNetWage($netWage);
        $salary->setGrossWage($grossWage);
        return $salary;
        /*
          <%SET_CONFIG( "", "LOCALE", "LC_TIME", "de_CH.utf8" )>
          <%VAR Boolean is13 = 0 %>
          <%VAR Date date %>
          <%IF 1 {
          <%Xdate.Set()%>
          } else {
          <%Xdate.Set(2019,2,23)%>
          }%>
          <%IF $Fdatum_monat && $Fdatum_jahr {
          <%IF $Fdatum_monat=='12' {
          <%Xis13 = 1 %>
          } else {
          <%Xis13 = 0 %>
          }%>
          } else {
          <%IF (date('m')=='12') {
          <%Xis13 = 1 %>
          } else {
          <%Xis13 = 0 %>
          }%>
          }%>
        */
    }
}
