class TimePublicTracker {
    constructor(timer) {
        this.timer = timer;
        this.employeeId = timer.getAttribute('data-employee-uid');
        this.buttonStart = timer.querySelector('.crm-time-start');
        this.buttonStop = timer.querySelector('.crm-time-stop');
        this.displayTime = timer.querySelector('.time-public-time');
        this.displayInfoToday = timer.querySelector('.time-public-info-today');
        this.displayInfoMonth = timer.querySelector('.time-public-info-month');
        this.startDate = null;
        this.init();
    }
    
    async saveTime(durationInSeconds, description) {
	const data = {
	    startDate: TimeFormat.formatDateTime(this.startDate),
	    durationInSeconds: durationInSeconds,
	    description: description,
	    employeeId: this.employeeId
	};
	try {
            const result = await TimeApi.add(data);
	    if (result.status.error > 0) {
		this.displayTime.innerHTML = '<span class="error">' + result.status.message + '</span>';
	    } else {
		let time = result.data;
		this.displayTime.innerHTML = TimeFormat.timePartFromString(time.startDate) + ' - ' + TimeFormat.timePartFromString(time.endDate) + ' = ' + TimeFormat.secondsToHHMMSS(time.duration);
		this.showInfo();
	    }
	} catch (error) {
	    // A Error occurred
	    console.log(error);
	};
    }
    async showInfo() {
	const info = await TimeApi.info({ employeeId: this.employeeId });
	this.displayInfoToday.innerHTML = `Heute: ${TimeFormat.secondsToHHMMSS(info.data.day.timeInSeconds)}`;
	this.displayInfoMonth.innerHTML = `Monat: ${TimeFormat.secondsToHHMMSS(info.data.month.timeInSeconds)}`;
    }

    
    init() {
	this.buttonStop.style.display = 'none';
        this.buttonStart.style.display = 'inline-block';

        this.buttonStart.addEventListener('click', () => {
            this.startDate = new Date();
	    this.displayTime.innerHTML = TimeFormat.timePartFromDate(this.startDate) + ' - ??:??:?? = ??:??:?? ';
	    this.showInfo();
            // @todo save start time to server with duration = 0 or null
            this.timer.view = null;
            this.buttonStop.style.display = 'inline-block';
            this.buttonStart.style.display = 'none';
        });

        this.buttonStop.addEventListener('click', () => {
            if (this.timer.view) {
                clearTimeout(this.timer.view);
                this.timer.view = null;
            }
            const endDate = new Date();
            const durationInSeconds = parseInt((endDate - this.startDate + 500) / 1000);
            this.saveTime(durationInSeconds, '');

            this.buttonStart.style.display = 'inline-block';
            this.buttonStop.style.display = 'none';
            this.startDate = null;
        });
    }
}

document.querySelectorAll('.crm-time-timer').forEach((timer, i) => {
    new TimePublicTracker(timer);
});
