const TimeApi = {
    apiAddUrl: '/de/api/ig-crm/time/add',
    apiListUrl: '/de/api/ig-crm/time/list',
    apiInfoUrl: '/de/api/ig-crm/time/info',
    
    init: function(apiAddUrl, apiListUrl, apiInfoUrl) {
	this.apiAddUrl = apiAddUrl;
	this.apiListUrl = apiListUrl;
	this.apiInfoUrl = apiInfoUrl;
    },
    
    fetch: async function(apiUrl, method, data) {
	return fetch(apiUrl, {
	    method: method,
	    headers: {
		"Content-Type": "application/json",
	    },
	    body: JSON.stringify(data),
	})
            .then((response) => {
                if (response.ok) {
                    return response.text();
                }
                throw new Error('Network or Server Problem');
            })
	    .then((responseData) => {
                try {
                    return JSON.parse(responseData);
                } catch (error) {
                    throw new Error('Error parsing JSON data');
                }
	    })
	    .catch(function (error) {
		// A Error occurred
		console.error("Abfrage fehlgeschlagen: " + error.message);
		return null;
	    });
    },
    add: async function(data) {
	return this.fetch(this.apiAddUrl, 'PUT', data);
    },
    list: async function(data) {
	return this.fetch(this.apiListUrl, 'POST', data);
    },
    info: async function(data) {
	return this.fetch(this.apiInfoUrl, 'POST', data);
    }
}

