const TimeTracker = {
    timeTracker: null,
    timeApi: TimeApi,
    //apiAddUrl: null,
    //apiListUrl: null,
    timer: null,
    startTime: null,
    buttonStart: null,
    buttonStop: null,
    buttonStopStart: null,
    buttonSave: null,
    buttonCancel: null,
    fieldDuration: document.getElementById('duration'),
    fieldStartDate: document.getElementById('startDate'),
    fieldEndTime: document.getElementById('endTime'),
    fieldActivity: document.getElementById('activity'),
    fieldEmployeeId: document.getElementById('employeeId'),
    fieldDescription: document.getElementById('fieldDescription'),
    trackerTimes: document.getElementById('trackerTimes'),
    trackerMessage: document.getElementById('trackerMessage'),
    
    init: function(selector) {
	this.timeTracker = document.querySelector(selector);
	//this.apiAddUrl = this.timeTracker.dataset.apiAddUrl;
	//this.apiListUrl = this.timeTracker.dataset.apiListUrl;
	//this.timeApi.init(this.apiAddUrl, this.apiListUrl, '/de/api/ig-crm/time/info');
	this.buttonStart = this.timeTracker.querySelector('.start');
	this.buttonStop = this.timeTracker.querySelector('.stop');
	this.buttonStopStart = this.timeTracker.querySelector('.stop-start');
	this.buttonCancel = this.timeTracker.querySelector('.cancel');
	this.buttonSave = this.timeTracker.querySelector('.save');
	if (this.buttonStart) {
            this.buttonStart.addEventListener('click', this.start.bind(this));
	}
	if (this.buttonStop) {
            this.buttonStop.addEventListener('click', this.stop.bind(this));
            this.buttonStopStart.addEventListener('click', this.stopAndStart.bind(this));
	}
	if (this.buttonSave) {
            this.buttonSave.addEventListener('click', this.save.bind(this));
	}
	if (this.buttonCancel) {
            this.buttonCancel.addEventListener('click', this.cancel.bind(this));
	}
	this.fieldDuration.addEventListener('change', this.changeDuration.bind(this));
	this.fieldStartDate.addEventListener('change', this.updateDuration.bind(this));
	this.fieldEndTime.addEventListener('change',this.updateDuration.bind(this));
	this.showHideButtonSave();
	this.updateTrackerTimes();
    },
    updateDuration: function () {
	let startDate = new Date(this.fieldStartDate.value);
	let endDate = new Date(TimeFormat.datePartFromDate(startDate) + 'T' + this.fieldEndTime.value);
	if (startDate > endDate) {
	    endDate.setDate(endDate.getDate() + 1);
	}
	this.fieldDuration.value = TimeFormat.millisecondsToTime(endDate-startDate);
	this.showHideButtonSave();
    },

    setStartTime: function() {
        this.startTime = new Date();
        this.fieldStartDate.value = TimeFormat.formatDateTime(this.startTime);
        this.updateTime();
    },

    getData: function() {
	let data = {
	    startDate: this.fieldStartDate.value.replace('T', ' '),
	    durationInSeconds: TimeFormat.timeToSeconds(this.fieldDuration.value),
	    //duration: this.fieldDuration.value,
	    //endTime: this.fieldEndTime.value,
	    description: this.fieldDescription.value,
	    activityUid: parseInt(this.fieldActivity.value),
	    employeeId: parseInt(this.fieldEmployeeId?.value)
	};
	return data;
    },
    updateTime: function() {
        let now = new Date();
        let elapsed = new Date(now - this.startTime);
        this.fieldDuration.value = TimeFormat.formatUTCTime(elapsed);
        this.fieldEndTime.value = TimeFormat.formatTime(now);
    },

    start: function() {
        this.setStartTime();
	this.showButtons(true);
        this.timer = setInterval(this.updateTime.bind(this), 1000);
    },

    stop: function() {
        clearInterval(this.timer);
	this.showButtons(false);
	let data = this.getData();
        this.setStartTime();
	this.saveTime(data);
    },

    stopAndStart: function() {
        clearInterval(this.timer);
	let data = this.getData();
        this.setStartTime();
        this.timer = setInterval(this.updateTime.bind(this), 1000);
	this.saveTime(data);	
    },    

    save: function() {
	let data = this.getData();
        this.setStartTime();
	this.showButtons(false);
	this.saveTime(data);
    },

    cancel: function() {
        clearInterval(this.timer);
	this.showButtons(false);
        this.setStartTime();
    },
    showButtons: function(isRunning) {
	if (this.buttonStart) {
	    this.buttonStart.style.display = isRunning ? 'none' : 'inline-block';
	    this.buttonStop.style.display = isRunning ? 'inline-block' : 'none';
	    this.buttonStopStart.style.display = isRunning ? 'inline-block' : 'none';
	    this.buttonCancel.style.display = isRunning ? 'inline-block' : 'none';
            this.buttonSave.style.display = 'none';
	}
    },

    changeDuration: function() {
	let duration = this.fieldDuration.value;
	let startDate = new Date(this.fieldStartDate.value);
	let endDate = startDate;
	let durationSeconds = TimeFormat.timeToSeconds(duration);
	endDate.setSeconds(endDate.getSeconds() + durationSeconds);
	this.fieldEndTime.value = TimeFormat.timePartFromDate(endDate);
	this.showHideButtonSave();	
    },

    showHideButtonSave: function() {
	if (this.buttonSave) {
	    if (this.fieldDuration.value == '00:00:00') {
		this.buttonSave.style.display = 'none';
		this.buttonCancel.style.display = 'none';
		this.buttonStart.style.display = 'inline-block';
	    } else {
		this.buttonSave.style.display = 'inline-block';
		this.buttonCancel.style.display = 'inline-block';
		this.buttonStart.style.display = 'none';
	    }
	}
    },
    TemplateMessage: function(
	header,
	message,
        severity
    ) {
	return `<div class="alert alert-${severity}">${header ? `<h4>${header}</h4>` : ''}${message ? `<p>${message}</p>` : ''}</div>`;
    },
    saveTime: function(data) {
	this.timeApi.add(data)
	    .then(data => {
		//console.log(data.data);
		if (data.status.error == 0) {
		    let startDate = data.data.startDate;
		    let duration = data.data.duration;
		    let datePart = TimeFormat.datePartFromStringFormatted(startDate);
		    let timePart = TimeFormat.timePartFromString(startDate);
		    if (this.trackerMessage) {
			this.trackerMessage.innerHTML = this.TemplateMessage('', 'Eintrag gespeichert: ' + datePart + ' ' + timePart + ' Dauer: ' + TimeFormat.secondsToHHMMSS(duration), 'info');
		    }
		    // update time list
		    this.updateTrackerTimes();
		} else {
		    if (this.trackerMessage) {
			this.trackerMessage.innerHTML = this.TemplateMessage('', data.status.message, 'warning');
		    }
		}
	    });
    },

    updateTrackerTimes: function() {
	let now = new Date();
	let search = {
	    startDate: TimeFormat.datePartFromDate(now) + ' 00:00:00',
	    endDate: TimeFormat.datePartFromDate(now) + ' 23:59:59',
	    employeeId: parseInt(this.fieldEmployeeId?.value)
	};
	const TemplateTimeLine = (
            time
	) => `<tr>
        <td>${time.activity.name}</td>
        <td>${time.description}</td>
        <td>${TimeFormat.formatAmount(time.activity.amount)}</td>
        <td>${TimeFormat.datePartFromStringFormatted(time.startDate)}</td>
        <td>${TimeFormat.timePartFromString(time.startDate)}</td>
        <td>${TimeFormat.timePartFromString(time.endDate)}</td>
        <td>${TimeFormat.secondsToHHMMSS(time.duration)}</td>
      </tr>`;
	const TemplateTimeFooter = (
            total
	) => `<tr>
        <td><b>Total</b></td>
        <td></td>
        <td>${TimeFormat.formatAmount(total.amount)}</td>
        <td></td>
        <td></td>
        <td></td>
        <td>${TimeFormat.secondsToHHMMSS(total.duration)}</td>
      </tr>`;
	
	this.timeApi.list(search)
	    .then(data => {
		//console.log(data.results);
		if (data.status.error == 0) {
		    let tbody = this.trackerTimes.querySelector('tbody');
		    let total = {duration: 0, amount: 0};
		    tbody.innerHTML = ''; // Clear existing rows
		    
		    data.results.forEach((time) => {
			total.duration += parseInt(time.duration);
			total.amount += parseInt(time.duration) / 3600 * time.activity.amount;
			tbody.insertAdjacentHTML('beforeend', TemplateTimeLine(time));
		    })
		    // set total to footer
		    let tfoot = this.trackerTimes.querySelector('tfoot');
		    tfoot.innerHTML  = TemplateTimeFooter(total);
		} else {
		    if (this.trackerMessage) {
			this.trackerMessage.innerHTML ='Network Error';
		    }
		}
	    })
	    .catch(error => {
		if (this.trackerMessage) {
		    this.trackerMessage.innerHTML = 'Error: ' + error.message;
		}
	    });
	
    }

};

TimeTracker.init('.time-tracker');
