<?php
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use Internetgalerie\IgCrmTimeRecording\Controller\ApiController;
use Internetgalerie\IgCrmTimeRecording\Controller\TimeController;
use Internetgalerie\IgCrmTimeRecording\Controller\ActivityController;
use Internetgalerie\IgCrmTimeRecording\Controller\HolidayController;
use Internetgalerie\IgCrmTimeRecording\Controller\EmployeeController;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

defined('TYPO3') || die();

(static function() {
    ExtensionUtility::configurePlugin(
        'IgCrmTimeRecording',
        'Api',
        [
            ApiController::class => 'add, list, info',
        ],
        // non-cacheable actions
        [
            ApiController::class => 'add, list, info',
        ]
    );
    ExtensionUtility::configurePlugin(
        'IgCrmTimeRecording',
        'Public',
        [
            TimeController::class => 'public',
        ],
        // non-cacheable actions
        [
            TimeController::class => 'public',
        ]
    );

    ExtensionUtility::configurePlugin(
        'IgCrmTimeRecording',
        'Tracking',
        [
            TimeController::class => 'tracker, add',
        ],
        // non-cacheable actions
        [
            TimeController::class => 'tracker, add',
        ]
    );


    ExtensionUtility::configurePlugin(
        'IgCrmTimeRecording',
        'Manage',
        [
            TimeController::class => 'list, show, new, create, edit, update, confirmDelete, delete, timeOff, add, overview, pdf, month',
            ActivityController::class => 'list, new, create, edit, update, confirmDelete, delete',
            HolidayController::class => 'list, new, create, edit, update, delete, import, targetTimes',
            EmployeeController::class => 'list, show, new, create, edit, update, confirmDelete, delete,wageStatement,monthlyTimeRecording, analytics'
        ],
        // non-cacheable actions
        [
            TimeController::class => 'list, show, new, create, edit, update, confirmDelete, delete, timeOff, add, overview, pdf, month',
            ActivityController::class => 'list, new, create, edit, update, confirmDelete, delete',
            HolidayController::class => 'list, new, create, edit, update, delete, import, targetTimes',
            EmployeeController::class => 'list, show, new, create, edit, update, confirmDelete, delete, wageStatement,monthlyTimeRecording, analytics'
        ]
    );

    // wizards
    ExtensionManagementUtility::addPageTSConfig(
        'mod {
            wizards.newContentElement.wizardItems.plugins {
                elements {
                    tracking {
                        iconIdentifier = ig_crm_time_recording-plugin-tracking
                        title = LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_ig_crm_time_recording_tracking.name
                        description = LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_ig_crm_time_recording_tracking.description
                        tt_content_defValues {
                            CType = list
                            list_type = igcrmtimerecording_tracking
                        }
                    }
                    manage {
                        iconIdentifier = ig_crm_time_recording-plugin-manage
                        title = LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_ig_crm_time_recording_manage.name
                        description = LLL:EXT:ig_crm_time_recording/Resources/Private/Language/locallang_db.xlf:tx_ig_crm_time_recording_manage.description
                        tt_content_defValues {
                            CType = list
                            list_type = igcrmtimerecording_manage
                        }
                    }
                }
                show = *
            }
       }'
    );
})();
