<?php

namespace Internetgalerie\IgDatapoolFe\Property\TypeConverter;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Property\Exception\TypeConverterException;
use TYPO3\CMS\Extbase\Property\PropertyMappingConfigurationInterface;
use TYPO3\CMS\Extbase\Property\TypeConverter\AbstractTypeConverter;

class TimeIntegerConverter extends AbstractTypeConverter
{
    /**
     * @var array<string>
     */
    protected $sourceTypes = array('string');

    /**
     * @var string
     */
    protected $targetType = 'int';



    protected $priority = 1;

    public function convertFrom($source, string $targetType, array $convertedChildProperties = array(), \TYPO3\CMS\Extbase\Property\PropertyMappingConfigurationInterface $configuration = null): ?int
    {
        if ($source === null || $source == '') {
            return null;
        }
        $hms = explode(':', $source);
        if (count($hms) == 2) {
            return ($hms[0] * 60 + $hms[1]) * 60;
        }
        if (count($hms) == 3) {
            return ($hms[0] * 60 + $hms[1]) * 60 + $hms[2];
        }
        return null;
    }
}
