<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\CheckboxViewHelper;

/**
 * View Helper which creates a checkbox (<input type="checkbox">) as a switch button (jQUery UI).
 *
 * = Examples =
 *
 * <code title="Examples">
 * <dp:form.switchButton name="mySwitchButton" value="someValue" />
 * <dp:form.switchButton name="mySwitchButton" value="someValue" checked="{object.value} == 5" />
 * <dp:form.switchButton property="interests" value="TYPO3" />
 * </code>
 */
class SwitchButtonViewHelper extends CheckboxViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();

        $this->registerArgument('onLabel', 'string', 'The Label for on', false, \Internetgalerie\IgDatapoolFe\Services\LangService::ll('field.switch.on'));
        $this->registerArgument('offLabel', 'string', 'The Label for off', false, \Internetgalerie\IgDatapoolFe\Services\LangService::ll('field.switch.off'));
    }


    /**
     * Renders the checkbox.
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        $pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        $pageRenderer->addJsFooterLibrary('ig_datapool_fe_switchbutton', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/jquery.switchbutton.js');
        //$GLOBALS['TSFE']->additionalFooterData['ig_datapool_fe_switchbutton'] = '<script src="/typo3conf/ext/ig_datapool_fe/Resources/Public/JavaScript/jquery.switchbutton.js"></script>';
        //render the checkbox
        $res = parent::render();
        //wrap it
        return '<div class="dp-switchbutton" data-onlabel="' . htmlspecialchars($this->arguments['onLabel']) . '" data-offlabel="' . htmlspecialchars($this->arguments['offLabel']) . '">' . $res . '</div>';
    }
}
