<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

trait ViewHelperTrait
{
    /**
     * @var \TYPO3\CMS\Extbase\Service\ExtensionService
     */
    protected $extensionService;

    protected $prefix = null;

    /**
     * @param \TYPO3\CMS\Extbase\Service\ExtensionService $extensionService
     */
    public function injectExtensionService(\TYPO3\CMS\Extbase\Service\ExtensionService $extensionService)
    {
        $this->extensionService = $extensionService;
    }
    /**
     * Returns the prefix for link arguments
     */
    public function getLinkPrefix()
    {
        if ($this->prefix == null) {
            $request = $this->renderingContext->getRequest();
            $extensionName = $request->getControllerExtensionName();
            $pluginName = $request->getPluginName();
            if ($extensionName !== null && $pluginName != null) {
                $this->prefix = $this->extensionService->getPluginNamespace($extensionName, $pluginName);
            } else {
                $this->prefix = '';
            }
        }
        return $this->prefix;
    }
}
