<?php

namespace Internetgalerie\IgDatapoolFe\Domain\Repository;

class Repository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    /**
     * Desc and asc shortcuts
     */
    public const ORDER_DESC = \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING;
    public const ORDER_ASC = \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING;

    /**
     * @var \Internetgalerie\IgDatapoolFe\Services\SearchLogicService
     */
    protected $searchLogicService;

    /**
     * @param \Internetgalerie\IgDatapoolFe\Services\SearchLogicService $searchLogicService
     */
    public function injectSearchLogicService(\Internetgalerie\IgDatapoolFe\Services\SearchLogicService $searchLogicService)
    {
        $this->searchLogicService = $searchLogicService;
    }

    public function initializeObject()
    {
        $this->searchLogicService = $this->searchLogicService??GeneralUtility::makeInstance(\Internetgalerie\IgDatapoolFe\Services\SearchLogicService::class);
    }
    /**
     * find All Ordered By
     *
     * @param $attr      string attribute to order
     * @param $direction int 0: acsending, 1:descending
     */
    public function findAllOrderedBy($attr, $direction = 0)
    {
        $order = array($attr => $direction ? \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING : \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING);
        $query = $this->createQuery();
        $result = $query->setOrderings($order)->executeQuery();
        return $result;
    }

    /**
     * find all elements that match the default searchlogic,
     * i.e. all formfield names have to be equal to the model's property names
     */
    public function findWithSearch()
    {
        $query = $this->createQuery();
        // apply the default search logic
        // initialize the search logic service and alias it as $s
        $s = $this->initSearch($query);
        // apply the default search->argumentName equals propertyName
        $s->apply(null);

        //set auto sorting
        $this->initAutoSorting($query);

        //exec and return
        return $query->executeQuery();
    }

    /**
     * Initializes the serach logic on a query
     */
    protected function initSearch(\TYPO3\CMS\Extbase\Persistence\QueryInterface $query)
    {
        //register in the viewhelper, that the search was initialized.
        \Internetgalerie\IgDatapoolFe\ViewHelpers\SearchFormViewHelper::$isInitializedInQuery = true;
        $this->searchLogicService->bind($query);
        return $this->searchLogicService;
    }

    /**
     * initializes the autosorting on a query
     */
    protected function initAutoSorting(\TYPO3\CMS\Extbase\Persistence\QueryInterface $query)
    {
        //register in the viewhelper, that autosorting is initializd
        \Internetgalerie\IgDatapoolFe\ViewHelpers\SortHeaderViewHelper::$isInitializedInQuery = true;
        $sorting = $this->searchLogicService->getAutoSorting();
        if ($sorting != null) {
            $query->setOrderings($sorting);
        }
    }

    /**
     * Demo Functions
     */
    public function findWithSearchLogic___()
    {
        die('This is just a demo, implement your own method!');

        $query = $this->createQuery();

        // initialize the search logic service and alias it as $s
        $s = $this->initSearch($query);

        // build logic and apply it to the query
        $s->apply($s->_and($s->greaterThan('geburtsdatum', 'bli'), $s->like('name', 'blu')));

        //execute
        return $query->execute();
    }

    public function findWithOldSearchLogic___()
    {
        die('This is just a demo, implement your own method!');
        $query = $this->createQuery();

        // initialize the search logic service and alias it as $s
        $s = $this->initSearch($query);

        $searchSQL = $s->yesImReallySureThatIWantToUseTheDeprecatedSearchLogic(
            '
	<searchRules>
		<AND0>
			<field1>
				<attr>kanton</attr>
				<formfield>kanton</formfield>
				<operation>=</operation>
			</field1>
			<OR2>
				<field3>
					<attr>praxisname</attr>
					<formfield>keyword</formfield>
					<operation>parse</operation>
				</field3>
				<field4>
					<attr>tierarzt</attr>
					<formfield>keyword</formfield>
					<operation>parse</operation>
				</field4>
			</OR2>
		</AND0>
	</searchRules>'
        );
        if ($searchSQL) {
            $searchSQL = 'WHERE ' . $searchSQL;
        }

        //execute
        return $query->statement('SELECT * FROM tx_extension_domain_model_stuff ' . $searchSQL);
    }
}
