<?php

namespace Internetgalerie\IgDatapoolFe\Services;

/**
 * This calss provides methods for acces checking and authorization
 */
class FormService implements \TYPO3\CMS\Core\SingletonInterface
{
    public const SUBFOLDER_NONE =0;
    public const SUBFOLDER_EXTENSION_CONTROLLER =1;
    public const SUBFOLDER_FEUSERID =2;


    /**
     * @var \TYPO3\CMS\Core\Resource\ResourceFactory
     */
    protected $resourceFactory;

    /**
     * Store the current controller
     */
    protected $controller = null;

    /**
     * Upload Folder
     */
    protected $uploadFolder = [];
    /**
     * Default Upload Folder
     */
    protected $defaultUploadFolder = '1:/';

    /**
     * Default Subfolder Upload Folder
     */
    protected $defaultSubfolderMode = self::SUBFOLDER_EXTENSION_CONTROLLER;

    /**
     * Store the last field
     */
    protected $field = null;

    /**
     * @param \TYPO3\CMS\Core\Resource\ResourceFactory $resourceFactory
     */
    public function injectResourceFactory(\TYPO3\CMS\Core\Resource\ResourceFactory $resourceFactory)
    {
        $this->resourceFactory = $resourceFactory;
    }

    public function setController($controller)
    {
        $this->controller = $controller;
    }
    public function getController()
    {
        return $this->controller;
    }

    public function setDefaultSubfolderMode($defaultSubfolderMode)
    {
        $this->defaultSubfolderMode = $defaultSubfolderMode;
    }
    public function getDefaultSubfolderMode()
    {
        return $this->defaultSubfolderMode;
    }



    public function setDefaultUploadFolder(string $defaultUploadFolder)
    {
        $this->defaultUploadFolder = $defaultUploadFolder;
    }
    public function getDefaultUploadFolder()
    {
        return $this->defaultUploadFolder;
    }
    public function getUploadFolder($propertyFolder = null, $subFolder = '')
    {
        $uploadFolderString=$this->defaultUploadFolder;
        /*
        if( $property!==null) {
            die('missing');
        }
        */
        $resourceStorage = $this->resourceFactory->getStorageObjectFromCombinedIdentifier($uploadFolderString);
        $rf=explode(':', $uploadFolderString);
        if (count($rf)!=2) {
            die('identifier not allowed: ' . $uploadFolderString);
        }
        
        $folder=trim($rf[1], '/');
        if ($this->defaultSubfolderMode==self::SUBFOLDER_EXTENSION_CONTROLLER && $this->controller) {
            $request = $this->controller->getRequest();
            $folder .= '/' . $request->getControllerExtensionName() . '/' . $request->getControllerName();
        } elseif ($this->defaultSubfolderMode==self::SUBFOLDER_FEUSERID) {
            $folder .= '/' .$GLOBALS['TSFE']->fe_user->user['uid'];
        } else if(!$propertyFolder) {
            $folder .= '/ext/form/uploads';

            if($subFolder) {
                $folder = $subFolder;
            }
        }
        if ($propertyFolder) {
            $folder.= '/' . $propertyFolder;
        }
        if ($resourceStorage->hasFolder($folder)) {
            return $resourceStorage->getFolder($folder);
        } else {
            return $resourceStorage->createFolder($folder);
        }
    }



    public function setField($field)
    {
        $this->field = $field;
    }
    public function getField()
    {
        return $this->field;
    }
}
