<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form\Inlinerecord;

use \Internetgalerie\IgDatapoolFe\ViewHelpers\Form\InlinerecordViewHelper;
use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;


class PrototypeViewHelper extends \TYPO3\CMS\Fluid\ViewHelpers\Form\AbstractFormFieldViewHelper
{
    /**
     * @var \TYPO3\CMS\Extbase\Security\Cryptography\HashService
     */
    protected $hashService;

    /**
     * @param \TYPO3\CMS\Extbase\Security\Cryptography\HashService $hashService
     */
    public function injectHashService(\TYPO3\CMS\Extbase\Security\Cryptography\HashService $hashService)
    {
        $this->hashService = $hashService;
    }
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('type', 'string', 'Type for this prototype', true);
        $this->registerArgument('label', 'string', 'Label for add button', false);
    }

    public function render(): string
    {

        $type = $this->arguments['type'];

        $viewHelperVariableContainer = $this->renderingContext->getViewHelperVariableContainer();
        $prototypeObjectName = $this->renderingContext->getViewHelperVariableContainer()->get(
            InlinerecordViewHelper::class,
            'prototypeObjectName'
        );
        if (empty($prototypeObjectName)) {            
            return 'no prototypeObjectName';
        }
        if (!$viewHelperVariableContainer->exists(InlinerecordViewHelper::class, $prototypeObjectName)) {
            if (!$viewHelperVariableContainer->exists(InlinerecordViewHelper::class, $prototypeObjectName . 'Button')) {
                return  'prototypeObjectName "' . $prototypeObjectName  . '" not found';
            }
            $prototypeButtons = $viewHelperVariableContainer->get(
                InlinerecordViewHelper::class,
                $prototypeObjectName . 'Button'
            );
            $renderedContent = $this->renderChildren();
            $prototypeButtons[] = [
                'label' => $this->arguments['label'] ?? $type,
                'type' => $type,
                'renderedContent' => $renderedContent
                ];
            $viewHelperVariableContainer->addOrUpdate(
                InlinerecordViewHelper::class,
                $prototypeObjectName . 'Button',
                $prototypeButtons
            );
            return '';//<div class="dp-record-prototype" data-type="' . $type . '">'. $renderedContent. '</div>';
        }
        
        $prototypeObject = $viewHelperVariableContainer->get(
            InlinerecordViewHelper::class,
            $prototypeObjectName
          );
        if ($type === '') {
            return $this->renderChildren();
        } elseif (method_exists($prototypeObject, 'getType')) {
            if ($prototypeObject->getType() === $type) {
                $templateVariableContainer = $this->renderingContext->getVariableProvider();
                $prefixName = $templateVariableContainer->get('prefixName');
                $property = $templateVariableContainer->get($prefixName);
                $this->arguments['property'] = $property;
                //$name = $this->getNameWithoutPrefix();
                $name = $this->getName();
                $hiddenTypeField = '<input type="hidden" name="' . $name . '[__type]" value="' . $type . '" />';
                return $this->renderChildren() . $hiddenTypeField;
            } else {
                return '';
            }
        }/* elseif (get_class($prototypeObject) == $type) {
            return $this->renderChildren();
            }*/
        return '';

            
        
        //return '<div class="dp-record ym-grid invoiceitem-line" data-type="' . $this->arguments['type'] . '">'. $this->renderChildren() . '</div>';
    }
}
