<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form\Slider;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class RangeViewHelper extends \Internetgalerie\IgDatapoolFe\ViewHelpers\Form\SelectViewHelper
{
    /**
     * Initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('min', 'float', 'min', false, 0);
        $this -> registerArgument('max', 'float', 'max', false, 100);
        $this -> registerArgument('step', 'float', 'step', false, 0);
        $this -> registerArgument('unit', 'string', 'unit', false);
    }


    /**
     * Render the tag.
     *
     * @return string rendered tag.
     * @api
     */
    public function render(): string
    {
        $name = $this->getName();
        $pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);

        $pageRenderer->addJsFooterLibrary('nouislider', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/noUiSlider/nouislider.js');
        $pageRenderer->addJsFooterLibrary('nouislider-init', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/noUiSlider/nouislider-init.js');
        $pageRenderer->addCssFile('EXT:ig_datapool_fe/Resources/Public/Css/nouislider.css');

        $min = $this->arguments['min'];
        $max = $this->arguments['max'];
        $step = $this->arguments['step'];
        $value = $this->arguments['value'];
        if (is_array($value)) {
            $fromValue = $value['from'] ?? $min;
            $toValue = $value['to'] ?? $max;
        } else {
            $v = explode(',', $value);
            $fromValue = $v[0] ?? $min;
            $toValue = $v[1] ?? $max;
        }
        $this->registerFieldNameForFormTokenGeneration($name);
        if ($min==$fromValue && $max==$toValue) {
            $valueSelected = false;
        } else {
            $valueSelected = true;
        }
        $unitContainerClass = 'dp-slider-range-container';
        if (isset($this->arguments['unit']) && $this->arguments['unit']) {
            $unitHtml = '<span class="dp-slider-range-unit">' . $this->arguments['unit'] . '</span>';
            $unitContainerClass .= ' dp-slider-range-container-unit';
        } else {
            $unitHtml = '';
        }
        $sliderClass = 'dp-slider-range';
        if ($valueSelected) {
            $sliderClass .= ' dp-slider-range-value-selected';
        }
        if ($this->arguments['class']) {
            $sliderClass .= ' ' . $this->arguments['class'];
        }
        return '<div class="' . $sliderClass . '">
<div class="dp-slider-range-slider" data-decimalpoint="." data-decimals="1"></div>
<div class="' . $unitContainerClass . ' dp-slider-range-container-from">
<input type="text" name="' . $name . '[from]" value="' . $fromValue . '" min="' . $min . '" max="' . $max . '" step="' . $step . '" class="dp-slider-range-input dp-slider-range-from" />' . $unitHtml . '
<input type="hidden" name="' . $name . '[min]" value="' . $min . '" class="dp-slider-range-hidden dp-slider-range-min" />
</div>
<div class="' . $unitContainerClass . ' dp-slider-range-container-to">
<input type="text" name="' . $name . '[to]" value="' . $toValue . '" min="' . $min . '" max="' . $max . '" step="' . $step . '" class="dp-slider-range-input dp-slider-range-to" />' . $unitHtml . '
<input type="hidden" name="' . $name . '[max]" value="' . $max . '" class="dp-slider-range-hidden dp-slider-range-max" />
</div>
</div>
      ';
    }
}
