<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\TextfieldViewHelper;

/**
 * View Helper which creates a slug field (BaseUrl/<input type="text"> + JS).
 */
class SlugViewHelper extends TextfieldViewHelper
{
    /**
     * Renders the textfield.
     *
     * @return string
     */
    public function render(): string
    {
        $iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        $icon = $iconFactory->getIcon(
            'actions-refresh',
            \TYPO3\CMS\Core\Imaging\Icon::SIZE_SMALL,
        );
        $title = LocalizationUtility::translate('LLL:EXT:core/Resources/Private/Language/locallang_core.xlf:buttons.recreateSlugExplanation');
        return '<div class="dp-form-slug">' . $this->renderChildren() . parent::render() . '<span title="' . $title . '">' . $icon . '</span></div>';
    }
}
