<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\SelectViewHelper;

class TokenMultiselectViewHelper extends Select2ViewHelper
{
    /**
     * initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->overrideArgument('options', 'mixed', 'Associative array with internal IDs as key, and the values are displayed in the select box', true);
        $this->overrideArgument('multiple', 'boolean', 'Associative array with internal IDs as key, and the values are displayed in the select box', false, true);
        $this->overrideArgument('style', 'string', '', false, 'width:100%;');
        //$this->registerArgument('default', 'array', 'Default Value');
    }

    public function render(): string
    {
        $this->createPageRendererForSelect2();
        //static::$pageRenderer->addCssFile('EXT:ig_datapool_fe/Resources/Public/Css/select2.css');

        if ($this->arguments['class']) {
            $this->tag->addAttribute('class', 'dp-tokenizer ' . $this->tag->getAttribute('class'));
            $this->arguments['class']= 'dp-tokenizer ' . $this->arguments['class']; // for errors
        } else {
            $this->tag->addAttribute('class', 'dp-tokenizer');
            $this->arguments['class']='dp-tokenizer'; // for errors
        }
        return  parent::render(); // error classen werden von select2 vom select tag geerbt
    }
}
