<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

//FormViewHelper
/**
 * SearchFormViewHelper
 */
class SearchFormViewHelper extends \TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper
{
    /**
     * is it initialized? this is set to true, if the Repository::initAutoSorting($query) method is called
     * if false, a warning is displayed.
     */
    public static $isInitializedInQuery = false;

    /**
     * Base Class for the wrapper div
     * Override this to add searchform
     */
    protected $divBaseClass = ['dp-form', 'dp-searchform']; // , 'ym-grid'

    /**
     * Render the form.
     *
     * @return string rendered form
     */
    public function render(): string
    {
        /*if ($action == null) {
            $action = 'list';
            }*/

        $this->viewHelperVariableContainer->add(\TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper::class, 'formClass', self::class);
        $ret = parent::render();
        //$action, $arguments, $controller, $extensionName, $pluginName, $pageUid, $object, $pageType, $noCache, $noCacheHash, $section, $format, $additionalParams, $absolute, $addQueryString, $argumentsToBeExcludedFromQueryString, $fieldNamePrefix, $actionUri, $objectName, $hiddenFieldClassName);
        $this->viewHelperVariableContainer->remove(\TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper::class, 'formClass');
        return $ret;
    }

    /**
     * remove __referrer
     */
    protected function renderHiddenReferrerFields(): string
    {
        return '';
    }

    /*
    public function buildHiddenSearchFields()
    {
        $out = '';

        $out .= '<input type="hidden" name="id" value="' . htmlspecialchars($GLOBALS['TSFE'] -> id) . '" />';
        $out .= '<input type="hidden" name="' . $this -> prefixFieldName('controller') . '" value="' . htmlspecialchars($this -> arguments['controller']) . '" />';
        if ($this -> arguments['action']) {
            $out .= '<input type="hidden" name="' . $this -> prefixFieldName('action') . '" value="' . htmlspecialchars($this -> arguments['action']) . '" />';
        }
        return $out;
    }
    */

    public function isSearchForm()
    {
        return true;
    }

    protected function getDefaultFieldNamePrefix(): string
    {
        return parent::getDefaultFieldNamePrefix() . '[@search]';
    }
}
