<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Widget\Controller;

class AbcnateController extends \TYPO3\CMS\Fluid\Core\Widget\AbstractWidgetController
{
    /**
     * @var array
     */
    protected $configuration = array('insertAbove' => false, 'insertBelow' => true, 'filter' => array(' '));

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     */
    protected $objects;

    /**
     * @var integer
     */
    protected $currentChar = null;

    /**
     * Parent Request
     */
    protected $parentRequest;

    /**
     * Property
     */
    protected $property;

    /**
     * @return void
     */
    public function initializeAction()
    {
        $this -> objects = $this -> widgetConfiguration['objects'];
        \TYPO3\CMS\Core\Utility\ArrayUtility::mergeRecursiveWithOverrule($this -> configuration, $this -> widgetConfiguration['configuration'], false);
        $this -> property = $this -> widgetConfiguration['property'];
        ;
        if (!$this -> property) {
            throw new \Exception('Abcnator: Kein Property gesetzt!');
        }
    }

    /**
     * @param  string $currentChar
     * @return void
     */
    public function indexAction($currentChar = null)
    {
        $this -> currentChar = $currentChar;
        if ($this -> currentChar) {
            // modify query
            $query = $this -> objects -> getQuery();
            $oldConstraints = $query -> getConstraint();
            $newConstraints = $query -> like($this -> property, $this -> currentChar . '%');
            if ($oldConstraints) {
                $newConstraints = $query -> logicalAnd(array($oldConstraints), $newConstraints);
            }
            $query -> matching($newConstraints);
            $modifiedObjects = $query -> execute();
        } else {
            $modifiedObjects = $this -> objects;
        }

        $this -> view -> assign('contentArguments', array($this -> widgetConfiguration['as'] => $modifiedObjects));
        $this -> view -> assign('configuration', $this -> configuration);
        $this -> view -> assign('abcList', $this -> buildAbcList($currentChar));
    }

    protected function buildAbcList($currentChar)
    {
        $abc = array();
        foreach ($this->objects as $o) {
            $letter = strtoupper(\TYPO3\CMS\Extbase\Reflection\ObjectAccess::getPropertyPath($o, $this -> property)[0]);
            if (in_array($letter, $this -> configuration['filter'])) {
                continue;
            }
            $abc[$letter] = $currentChar == $letter;
        }
        ksort($abc);
        return $abc;
    }

    public function setParentRequest($request)
    {
        $this -> parentRequest = $request;
    }

    /**
     * Allows the widget template root path to be overriden via the framework configuration,
     * e.g. plugin.tx_extension.view.widget.<WidgetViewHelperClassName>.templateRootPath
     *
     * @param  \TYPO3\CMS\Extbase\Mvc\View\ViewInterface $view
     * @return void
     */
    protected function setViewConfiguration(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface $view)
    {
        $rootPath = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath($this -> parentRequest -> getControllerExtensionKey());
        $templatePathAndFilename = $rootPath . 'Resources/Private/Partials/' . $this -> parentRequest -> getControllerName() . '/AbcBrowser.html';
        if (!file_exists($templatePathAndFilename)) {
            $templatePathAndFilename = $rootPath . 'Resources/Private/Partials/AbcBrowser.html';
        }
        $view -> setTemplatePathAndFilename($templatePathAndFilename);
    }
}
