IGDATAPOOLFE = {
    forms: {},
    addForm: function(form, name) {
	this.forms[name] = form;
	form.initDPForm = function() {
	    let form = this;
	    // disable the enter key for form submission
	    form.querySelectorAll('.dp-form:not(.dp-searchform)').forEach(function(el) {
		['keypress', 'keyup'].forEach(function(eventType) {
		    window.addEventListener(eventType, function(e) {
			let tagName = $(e.target).prop('tagName');
			if (tagName == 'TEXTAREA' || tagName == 'DIV')
			    return;
			if (e.which == 13)
			    e.preventDefault();
		    });
		});
	    });
	    IGDATAPOOLFE.plugins.forEach(function (plugin, index) {
		plugin.init(form);
	    });
	};
	form.initFields = function(form) {
	    IGDATAPOOLFE.plugins.forEach(function (plugin, index) {
		if (typeof plugin.initFields === "function") { 
		    plugin.initFields(form);
		}
	    });
	};

	form.initDPForm();
	//console.log('IGDATAPOOLFE.addForm:' + form);
    },
};
IGDATAPOOLFE.pluginManager = function () {
    this.registered = {};
};
IGDATAPOOLFE.pluginManager.prototype = {    
    add: function(name, plugin){
	//console.log('add: ' + name);
	if(this.registered[name]) {
	    throw Error('[IGDATAPOOLFE.plugin.add] The resource name "' + name + '" is already registered.');
	} else {
	    this.registered[name] = plugin;
	}
    },
    forEach: function(func) {
	for (var name in this.registered) {
	    func(this.registered[name], name);
	}
    },
    getRegistered: function() {
	return this.registered;
    }
};
IGDATAPOOLFE.plugins = new IGDATAPOOLFE.pluginManager();
