<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;


use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;

class DatetimeViewHelper extends TextfieldViewHelper
{

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->overrideArgument('type', 'string', 'The field type, e.g. "text", "email", "url" etc.', false, 'datetime-local');
        $this->overrideArgument('class', 'string', 'Label', false, 'dp-datetime');
        $this->registerTagAttribute('min', 'string', 'Minimum DateTime', false);
        $this->registerTagAttribute('max', 'string', 'Maximum DateTime', false);
        $this->registerTagAttribute('step', 'string', 'Step', false);
        //$this->registerArgument('dateFormat', 'string', 'Format for output', false, 'dd.mm.yyyy');
        $this->registerArgument('formatSubmit', 'string', 'Format Submit', false, 'Y-m-d\\TH:i:s');
        $this->registerArgument('typeConverterDateFormat', 'string', 'date format for DateTimeConverter (field dateFormat)', false);
    }
    public function render(): string
    {
        $res = parent::render();

        // CAVEAT: this has to match the formatSubmit (format in js: yyyy-mm-dd, format in php Y-m-d)
        $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
        $res .= '<input type="hidden" name="' . parent::getName() . '[dateFormat]" value="' . htmlspecialchars($typeConverterDateFormat) . '" />';
        return $res;
    }

    protected function getName(): string
    {
        return parent::getName() . '[date]';
    }
    
    /**
     * Get the value of this form element.
     * Either returns arguments['value'], or the correct value for Object Access.
     *
     * @param  boolean $convertObjects whether or not to convert objects to identifiers
     * @return mixed Value
     */
    protected function getValueAttribute($convertObjects = true)
    {
        $value = parent::getValueAttribute();
        if (is_array($value)) {
            $converter = GeneralUtility::makeInstance(DateTimeConverter::class);
            // set default dateformat if nothing is set
            if (isset($value['date']) && (!isset($value['dateFormat']) || $value['dateFormat'] === '')) {
                $value['dateFormat'] = $this->getTypeConverterFormatSubmit();
            }
            $value = $converter->convertFrom($value, 'DateTime', [], null);
        }

        if (is_a($value, \DateTime::class)) {
            //$typeConverterDateFormat = $this->getTypeConverterDateFormat();
            $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
            return $value->format($typeConverterDateFormat);
        }
        return $value;
    }

    /**
     * Format date for
     */
    protected function getTypeConverterFormatSubmit()
    {
        if (isset($this->arguments['typeConverterDateFormat'])) {
            return $this->arguments['typeConverterDateFormat'];
        }
        $typeConverterDateFormat = $this->arguments['formatSubmit'];
        $typeConverterDateFormat = str_replace('yyyy', 'Y', $typeConverterDateFormat);
        return str_replace(['yy', 'mm', 'dd'], ['y', 'm', 'd'], $typeConverterDateFormat);
    }

    /**
     * Format date for output
     */
    protected function getTypeConverterDateFormat()
    {
        $typeConverterDateFormat = $this->arguments['dateFormat'];
        $typeConverterDateFormat=str_replace('yyyy', 'Y', $typeConverterDateFormat);
        return str_replace(['yy', 'mm', 'dd'], ['y', 'm', 'd'], $typeConverterDateFormat);
    }
}
