<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class HiddenDateViewHelper extends HiddenViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('formatSubmit', 'string', 'Format Submit', false, 'yyyy-mm-dd');
        $this->registerArgument('typeConverterDateFormat', 'string', 'date format for DateTimeConverter (field dateFormat)', false);
    }

    public function render(): string
    {
        return parent::render() . $this->renderHiddenDateFormat();
    }

    public function renderHiddenDateFormat(): string
    {
        $options = [];
        $options['formatSubmit'] =  $this->arguments['formatSubmit'];

        $value = $this->getValueAttribute();

        if ($this->isObjectAccessorMode()) {
            $value = $this->getPropertyValue();
        }

        //$value = $this->convertToPlainValue($value);
        // is property Value
        if ($value instanceof \DateTime) {
            $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
            $value = $value->format($typeConverterDateFormat);
            //$value = $value->format('Y-m-d');
        }

        // CAVEAT: this has to match the formatSubmit (format in js: yyyy-mm-dd, format in php Y-m-d)
        $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
        return '<input type="hidden" name="' . parent::getName() . '[dateFormat]" value="' . htmlspecialchars($typeConverterDateFormat) . '" />';
    }


    
    protected function getName(): string
    {
        return parent::getName() . '[date]';
    }

    /**
     * Get the value of this form element.
     * Either returns arguments['value'], or the correct value for Object Access.
     *
     * @param  boolean $convertObjects whether or not to convert objects to identifiers
     * @return mixed Value
     */
    protected function getValueAttribute($convertObjects = true)
    {
        $value = parent::getValueAttribute();
        if (is_array($value)) {
            $converter = GeneralUtility::makeInstance(DateTimeConverter::class);
            // set default dateformat if nothing is set
            if (isset($value['date'])) {
                $value['dateFormat'] = $this->getTypeConverterFormatSubmit();
            }
            $value = $converter->convertFrom($value, 'DateTime', [], null);
        }

        if (is_a($value, \DateTime::class)) {
            $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
            return $value->format($typeConverterDateFormat);
        }
        return $value;
    }

    /**
     * Format date for
     */
    protected function getTypeConverterFormatSubmit()
    {
        if (isset($this->arguments['typeConverterDateFormat'])) {
            return $this->arguments['typeConverterDateFormat'];
        }
        $typeConverterDateFormat = $this->arguments['formatSubmit'];
        $typeConverterDateFormat = str_replace('yyyy', 'Y', $typeConverterDateFormat);
        return str_replace(['yy', 'mm', 'dd'], ['y', 'm', 'd'], $typeConverterDateFormat);
    }
}
