<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

/**
 * View Helper which creates a text field (<input type="text">).
 *
 * = Examples =
 *
 * <code title="Example">
 * <f:form.textfield name="myTextBox" value="default value" />
 * </code>
 * <output>
 * <input type="text" name="myTextBox" value="default value" />
 * </output>
 *
 * @api
 * @author     Markus Baumgartner, Daniel Abplanalp, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */

use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;

class TextfieldViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\TextfieldViewHelper implements FieldInterface
{
    use FormFieldTrait;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('default', 'string', 'Default Value');
    }
    public function setArguments(array $arguments)
    {
        if ($this->viewHelperVariableContainer->exists(\TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper::class, 'fieldWrapperFields')) {
            $fieldWrapperFields = $this->viewHelperVariableContainer->get(\TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper::class, 'fieldWrapperFields');

            $fieldWrapperFields[] = $this;
            $this->viewHelperVariableContainer->addOrUpdate(\TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper::class, 'fieldWrapperFields', $fieldWrapperFields);
        }
        /*
        if (isset($arguments['default'])) {
            if ($this->isObjectAccessorMode()) {
                // @todo use $this->persistenceManager->isNewObject();
                $viewHelperVariableContainer = $this->renderingContext->getViewHelperVariableContainer();
                if ($viewHelperVariableContainer->exists(
                    FormViewHelper::class,
                    'formObject'
                )
                ) {
                    $formObject = $viewHelperVariableContainer->get(
                        FormViewHelper::class,
                        'formObject'
                    );
                    $uid = \TYPO3\CMS\Extbase\Reflection\ObjectAccess::getPropertyPath($formObject, 'uid');
                    if (!$uid)  {
                        $arguments['value'] = $arguments['default'];
                    }
                }
            }
        }
        */
        parent::setArguments($arguments);
        //doesnt really fit here, but it works
        //\Internetgalerie\IgDatapoolFe\ViewHelpers\FieldWrapperViewHelper::setField($this);
    }
}
