<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Creates a Form Tab-Navigation based on the inner Tabs
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class TabNavigationViewHelper extends AbstractAggregateViewHelper
{
    /**
     * Stores references to child elements
     *
     * @var array
     */
    protected $children = array();

    /**
     * 3
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
    }
    private function renderTabHeader($menu, $elem, $baseClass)
    {
        $classes = array('dp-' . $baseClass);
        $classes[] = 'dp-' . $baseClass . '-' .  $menu['name'];
        /*
        if ($this->hasError()) {
            $classes[] = 'dp-' . $baseClass . '-error';
        }
        */
        if ($menu['class'] && $elem=='li') {
            $classes[] = $menu['class'];
        }
        if ($this->hasArgument('headerClass') && $elem=='li') {
            $classes[] = $this->arguments['headerClass'];
        }

        //tabsToSteps: enable if current
        /*        if (FormViewHelper::$curForm->isStepForm() && FormViewHelper::$curForm->getCurrentStep() == $this->getTabNumber()) {
            $classes[] = 'dp-' . $baseClass . '-active';
            }*/

        return '<' . $elem . ' class="' . implode(' ', $classes) . '" data-rel="' . $menu['name'] . '">
	<a class="dp-' . $baseClass . '-link" href="#' . $menu['name'] . '" onclick="return false">' . htmlspecialchars($menu['title']) . '</a>
</' . $elem . '>';
    }
    /**
     * Renders the checkbox.
     *
     * @return string
     * @api
     */
    public function render()
    {
        $tabsUtility = GeneralUtility::makeInstance(\Internetgalerie\IgRender\Utility\TabsUtility::class);

        TabViewHelper::$tabCount = 0;
        $innerContent = $this->renderChildren();
        //$innerContent = $this -> renderAggregateChildren();

        $out = '';

        foreach ($tabsUtility->getMenu() as $menu) {
            $out .= $this->renderTabHeader($menu, 'li', 'tabHeader');
        }

        $hidden = '';
        if (0 && FormViewHelper::$curForm -> isStepForm()) {
            // stepCount
            $hidden = '<input type="hidden" name="' . $this -> prefixFieldName('stepCount') . '" value="' . count($this -> children) . '" />';
            // nextStep
            $hidden .= '<input type="hidden" class="currentStep" name="' . $this -> prefixFieldName('step') . '" value="' . FormViewHelper::$curForm -> getCurrentStep() . '" />';
            // the naming here is a bit strange...
            $hidden .= '<input type="hidden" name="' . $this -> prefixFieldName('lastStep') . '" value="' . FormViewHelper::$curForm -> getCurrentStep() . '" />';

            $stepArray = array('count' => count($this -> children), 'current' => FormViewHelper::$curForm -> getCurrentStep() + 1);
            $this -> templateVariableContainer -> add('steps', $stepArray);
            if (FormViewHelper::$curForm -> getVariableProvider() -> exists('steps')) {
                FormViewHelper::$curForm -> getVariableProvider() -> remove('steps');
            }
            FormViewHelper::$curForm -> getVariableProvider() -> add('steps', $stepArray);
        }
        return $hidden . '
<ul class="dp-tabNavigation">
' . $out . '
</ul>
<div class="dp-tabContainer">
' . $innerContent . '
</div>';
    }

    /**
     * Add a Tab
     *
     * @param  Internetgalerie\IgDatapoolFe\ViewHelpers\Aggregate $agg
     * @throws \TYPO3Fluid\Fluid\Core\ViewHelper\Exception
     * @return void
     */
    public function addAggregate(AggregateInterface $agg)
    {
        if (get_class($agg) != 'Internetgalerie\IgDatapoolFe\ViewHelpers\TabViewHelper') {
            throw new \TYPO3Fluid\Fluid\Core\ViewHelper\Exception('TabNavigation only supports Tabs as children');
        }
        $this -> children[] = $agg;
    }
}
