<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

/**
 * Extends the TranslateViewHelper
 *
 * Why is this one different to ig_render? Here we first check the local extension and THEN the ig_render.
 * In ig_render it is the other way around.
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Fluid\Core\ViewHelper\Exception\InvalidVariableException;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

class TranslateViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\TranslateViewHelper
{
    public function render()
    {
        $out = \Internetgalerie\IgDatapoolFe\Services\LangService::ll($this -> arguments['key'], 'ig_datapool_fe', 'main', $this->arguments['arguments']);
        if ($out) {
            return $out;
        }
        return parent::render();
    }

    /**
     * Renders a buttons div
     *
     * @param  array                     $arguments
     * @param  \Closure                  $renderChildrenClosure
     * @param  RenderingContextInterface $renderingContext
     * @throws InvalidVariableException
     * @return string
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext): string
    {
        //    return $this->arguments['key'] .'='. parent::render($this->arguments['key'], 'igRender', $this->arguments['arguments']);

        $out = \Internetgalerie\IgDatapoolFe\Services\LangService::ll($arguments['key'], 'ig_datapool_fe', 'main', $arguments['arguments']);
        if ($out) {
            return strval($out);
        }
        return parent::renderStatic($arguments, $renderChildrenClosure, $renderingContext);
    }
}
