<?php

declare(strict_types=1);

use Internetgalerie\IgDatapoolFe\Controller\AjaxUploadController;
use Internetgalerie\IgDatapoolFe\Mvc\Property\PropertyMappingConfiguration;
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;

defined('TYPO3') or die();


if ((new \TYPO3\CMS\Core\Information\Typo3Version())->getMajorVersion() < 12)
{

    /**
     * DateTime Converter for dates without seconds
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\DateTimeConverter::class);

   \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\HtmlConverter::class);

    /**
     * Type Converter for FileReferences
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\FileReferenceConverter::class);

    /**
     * Type Converter for ObjectStorage: does not store NULL
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\ObjectStorageConverter::class);


    /**
     * Type Converter for File
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\FileConverter::class);
}
// config.tx_extbase.persistence.classes is in File Configuration/Extbase/Persistence/Classes.php
// config.tx_extbase.objects { TYPO3\CMS\Extbase\Domain\Model\FileReference.className = Internetgalerie\IgDatapoolFe\Domain\Model\FileReference }
//\TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\Object\Container\Container::class)
//    ->registerImplementation(\TYPO3\CMS\Extbase\Domain\Model\FileReference::class, \Internetgalerie\IgDatapoolFe\Domain\Model\FileReference::class);

// FE file upload processing
$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['ext/form']['afterBuildingFinished'][1489772699]
    = PropertyMappingConfiguration::class;
$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['ext/form']['afterFormStateInitialized'][1613296803]
    = PropertyMappingConfiguration::class;

ExtensionUtility::configurePlugin(
    // extension name, matching the PHP namespaces (but without the vendor)
    'IgDatapoolFe',
    // arbitrary, but unique plugin name (not visible in the backend)
    'AjaxUpload',
    // all actions
    [AjaxUploadController::class => 'ajaxUpload'],
    // non-cacheable actions
    [AjaxUploadController::class => 'ajaxUpload'],
);
