<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * View Helper which creates a simple Password Text Box (<input type="password">).
 *
 * = Examples =
 *
 * <code title="Example">
 * <dp:form.password property="name2" minEntropy="15" maxEntropy="25"  />
 * </code>
 * <output>
 * <input type="password" name="myPassword" value="default value" />
 * </output>
 */
class PasswordViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\PasswordViewHelper implements FieldInterface
{
    //use FormFieldTrait;
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('disableIndicator', 'boolean', 'Disable the indicator?', false, false);
        $this->registerArgument('minEntropy', 'integer', 'The necessary entropy for a good password. 0 < 28 easily breakable, 28<35: weak, desktop login, 36 < 59: strong (internet), 60 <: very strong, financial stuff ', false, '15');
        $this->registerArgument('maxEntropy', 'integer', 'The necessary entropy for a good password. 0 < 28 easily breakable, 28<35: weak, desktop login, 36 < 59: strong (internet), 60 <: very strong, financial stuff ', false, '25');
        $this->registerArgument('labels', 'integer', 'commaseparated list of label ids', false, 'field.password.tooweak, field.password.weak, field.password.medium, field.password.strong');
    }

    /**
     * Renders the password input field.
     *
     * @see http://rumkin.com/tools/password/passchk.php
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        $pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        $pageRenderer->addJsFooterLibrary('ig_datapool_fe_password', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/password/passchk.js');
        //$GLOBALS['TSFE']->additionalFooterData['ig_datapool_fe_password'] = '<script src="/typo3conf/ext/ig_datapool_fe/Resources/Public/JavaScript/password/passchk.js"></script>';
        $name = $this->getName();
        $this->registerFieldNameForFormTokenGeneration($name);

        $this->tag->addAttribute('type', 'password');

        /*
         * as long as the field is not change, the value is not submitted
         * on change, the "dummy-" is removed and the field is mapped.
         */
        $this->tag->addAttribute('name', 'dummy-' . $name);

        //the actual value is never shown, instaed, a dummy value is shown
        $value = '';
        if ($this->getValueAttribute() != '') {
            $value = str_shuffle('0123456789');
        }
        $this->tag->addAttribute('value', $value);

        $this->setErrorClassAttribute();

        $class = '';
        $indicatorDiv = '';
        if (!$this->arguments['disableIndicator']) {
            $class = 'dp-password-indicator';
            $indicatorDiv = '
	<div class="dp-indicator-wrapper">
        <div class="dp-indicator"></div>
    </div>';
        }

        //get the labels
        $labelArr = \TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(',', $this->arguments['labels'], true);
        $prefix = \Internetgalerie\IgDatapoolFe\Services\LangService::ll('field.password.strength');
        foreach ($labelArr as &$val) {
            $val = $prefix . ' ' . \Internetgalerie\IgDatapoolFe\Services\LangService::ll($val);
        }

        $this->tag->addAttribute('autocomplete', 'off');

        return '<div class="dp-password ' . $class . '" data-labels="' . htmlentities(json_encode($labelArr)) . '" data-entropy="' . htmlentities(json_encode(array('min' => $this->arguments['minEntropy'], 'max' => $this->arguments['maxEntropy']))) . '">
	' . $this->tag->render() . $indicatorDiv . '
</div>';
    }
}
