<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\TextfieldViewHelper;

/**
 * View Helper which creates a slug field (BaseUrl/<input type="text"> + JS).
 */
class SlugViewHelper extends TextfieldViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('contentPosition', 'string', 'Content Position', 'before');
        $this->registerArgument('containerClass', 'string', 'Additional Container Class', '');
    }
    /**
     * Renders the textfield.
     *
     * @return string
     */
    public function render(): string
    {
        $iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        $icon = $iconFactory->getIcon(
            'actions-refresh',
            \TYPO3\CMS\Core\Imaging\Icon::SIZE_SMALL,
        );
        $css = $this->arguments['containerClass'];
        $title = LocalizationUtility::translate('LLL:EXT:core/Resources/Private/Language/locallang_core.xlf:buttons.recreateSlugExplanation');
        $contentAndInput = $this->arguments['contentPosition'] == 'after' ? parent::render() . $this->renderChildren() : $this->renderChildren() . parent::render();
        return '<div class="dp-form-slug' . ($css ? ' ' . $css : '') . '">' . $contentAndInput . '<span title="' . htmlspecialchars($title) . '">' . $icon . '</span></div>';
    }
}
