<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Link;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;

/**
 * Creates a Sort-Link Header
 */
class SortingViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'a';

    /**
     * Arguments initialization
     *
     * @return void
     */
    public function initializeArguments()
    {
        $this->registerUniversalTagAttributes();
        $this->registerArgument('property', 'string', 'The Property', true, '');

        $this->registerTagAttribute('name', 'string', 'Specifies the name of an anchor');
        $this->registerTagAttribute('rel', 'string', 'Specifies the relationship between the current document and the linked document');
        $this->registerTagAttribute('rev', 'string', 'Specifies the relationship between the linked document and the current document');
        $this->registerTagAttribute('target', 'string', 'Specifies where to open the linked document');
        $this->registerArgument('label', 'string', 'Override label', false, '');
        $this->registerArgument('pageUid', 'integer', 'pageUid of the link', false, '');
    }

    /**
     * Render a sortlink
     *
     * @return string
     * @api
     */
    public function render()
    {
        // get the label
        $label = '';
        if ($this->arguments['label']) {
            $label = $this->arguments['label'];
        } else {
            $label = $this->renderChildren();
            /*
            if (!$label) {
                $label = \Internetgalerie\IgDatapoolFe\Utility\NeedfulThings::getFieldLabelByProperty($this->arguments['property']);
            }
            */
        }
        if (!$this->arguments['class']) {
            $class = ' dp-sortlink ';
        } else {
            $class = $this->arguments['class'];
        }

        /*
        // controller...
        $arguments = array('@sorting' => implode('_', $newSorting));
        */


        // ist dies korrekt oder einfach vom letzten Link her -> alles vom request nehmen
        //$arguments= $uriBuilder->getArguments();
        $request = $this->renderingContext->getRequest();
        $arguments = $request->getArguments();
        if (!isset($arguments['search'])) {
            $arguments['search'] = [];
        }

        $sorting = $arguments['search']['sorting'] ?? '';
        $property = $this->arguments['property'];
        $properties = GeneralUtility::trimExplode(',', $property, true);
        $sortingAsc = implode(' asc,', $properties) . ' asc';
        $sortingDesc = implode(' desc,', $properties) . ' desc';
        if ($sorting == $sortingAsc) {
            $arguments['search']['sorting'] = $sortingDesc;
            $class .= ' dp-sortlink-0';
        } else {
            $arguments['search']['sorting'] = $sortingAsc;
            if ($sorting == $sortingDesc) {
                $class .= ' dp-sortlink-1';
            }
        }

        //$arguments['search']['sorting'] = isset($arguments['search']['sorting']) &&  $arguments['search']['sorting'] == $this->arguments['property'] . ' asc' ? $this->arguments['property'] . ' desc' : $this->arguments['property'] . ' asc';
        //$uriBuilder = $uriBuilder->setArguments($arguments);//->reset()->setArguments(array($this->getLinkPrefix() => $arguments));

        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        $uriBuilder
            ->reset()
            ->setRequest($request);

        if ($this->arguments['pageUid']) {
            $uriBuilder->setTargetPageUid($this->arguments['pageUid']);
        }
        $uri = $uriBuilder->uriFor('list', $arguments);

        $this->tag->addAttribute('class', $class);
        $this->tag->addAttribute('href', $uri);
        $this->tag->setContent($label);
        $this->tag->forceClosingTag(true);
        return $this->tag->render();
    }
}
