<?php

namespace Internetgalerie\IgDatapoolFe\Property\TypeConverter;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Property\Exception\TypeConverterException;
use TYPO3\CMS\Extbase\Property\PropertyMappingConfigurationInterface;
use TYPO3\CMS\Extbase\Property\TypeConverter\AbstractTypeConverter;

class ArrayStringConverter extends AbstractTypeConverter
{
    /**
     * @var array<string>
     */
    protected $sourceTypes = ['array'];

    /**
     * @var string
     */
    protected $targetType = 'string';



    protected $priority = 1;
    /*
    public function log($text)
    {
        $fp = fopen('/tmp/log.txt', 'a');
        fputs($fp, $text ."\n");
        fclose($fp);
    }
    */

    public function convertFrom($source, string $targetType, array $convertedChildProperties = [], \TYPO3\CMS\Extbase\Property\PropertyMappingConfigurationInterface $configuration = null): ?string
    {
        //$this->log("\n-----------------------------------------------------\nINIT ArrayStringConverter.php: array -> sTring");
        //        $this->log_var_dump( $source );
        if ($source === '') {
            return null;
        }
        return implode(',', $source);
    }
}
