<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use Internetgalerie\IgDatapoolFe\ViewHelpers\Form\AbstractFileReferenceViewHelper;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class FileViewHelper extends AbstractFileViewHelper
{
    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('defaultLangValue', 'string', 'language Value');
    }
    /**
     * Renders the upload field with possible resource pointer
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        $this->formUtility->addJsFooter();
        $this->prepareOptions();

        if ($this->dragAndDrop) {
            $this->cssClasses[]='dp-dropzone';
        }

        $value = $this->getValueAttribute();//getValueAttributeAttribute();
        //$value = $this->getUploadedResource();//


        $this->labels = [];
        $this->labels['type_error'] = \Internetgalerie\IgDatapoolFe\Services\LangService::ll('validator.file.invalidType', 'ig_datapool_fe');
        $this->labels['size_error'] = \Internetgalerie\IgDatapoolFe\Services\LangService::ll('validator.file.tooBig', 'ig_datapool_fe');

        return $this->renderHtml($value);
    }

    protected function renderInputFields($currentValue, $options)
    {
        $this->registerFieldNameForFormTokenGeneration($this->getName());
        return $this->formUtility->renderFileInputFields($this->getName(), $currentValue, $options);
    }
}
