<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Format;

/**
 * Creates an InfoBubble
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class TimeViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper
{
    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments()
    {
        $this -> registerArgument('time', 'string', 'Time to format', false, '');
        //$this -> registerArgument('style', 'int', 'Style', FALSE, '0');
    }

    /**
     * Renders a tooltip element
     *
     * @return string
     */
    public function render()
    {
        $time =$this -> arguments['time']!==null ? $this -> arguments['time'] : $this -> renderChildren();
        if (strlen($time)==0) {
            return '';
        }
        $h=intval($time/3600);
        $m=intval($time/60)%60;
        return sprintf('%02d:%02d', $h, $m);
    }
}
