
document.querySelectorAll(".dp-marker-list").forEach(
    function(crmInsert) {
	let inputId = crmInsert.getAttribute('data-input-id');
	crmInsert.querySelectorAll("[data-marker],[data-html]").forEach(
	    function(el) {
		el.addEventListener("click", function() {
		    let marker = this.getAttribute('data-marker');
		    let html = selectedOptionTag.getAttribute('data-html');
		    if (marker) {
			html = '{' + marker + '}';
		    }
		    let editor = IGDATAPOOLFE.ckeditors[inputId];
		    editor.model.change( writer => {
			writer.insertText( html, editor.model.document.selection.getFirstPosition() );
		    });
		});
	    }
	);
    }
);
document.querySelectorAll(".dp-marker-select").forEach(
    function(crmInsert) {
	let inputId = crmInsert.getAttribute('data-input-id');
	crmInsert.addEventListener("change", function(e) {
	    let selectTag = e.target;
	    let selectedOptionTag = selectTag.options[selectTag.selectedIndex];
	    let marker = selectedOptionTag.getAttribute('data-marker');
	    let html = selectedOptionTag.getAttribute('data-html');
	    if (marker) {
		html = '{' + marker + '}';
	    }
	    if (html) {
		let editor = IGDATAPOOLFE.ckeditors[inputId];
		if (editor) {
		    editor.model.change( writer => {
			writer.insertText( html, editor.model.document.selection.getFirstPosition() );
		    });
		} else {
		    // textarea
		    const myTextarea = document.getElementById(inputId);
		    const start = myTextarea.selectionStart;
		    const end = myTextarea.selectionEnd;
		    const textBeforeCursor = myTextarea.value.substring(0, start);
		    const textAfterCursor = myTextarea.value.substring(end, myTextarea.value.length);

		    myTextarea.value = textBeforeCursor + html + textAfterCursor;
		    // set cursor after text, unselect all
		    myTextarea.selectionStart = start+ html.length;
		    myTextarea.selectionEnd = start + html.length;
		}
		selectTag.options.selectedIndex = 0;
	    }

	});
    }
);
