<?php

namespace Internetgalerie\IgDatapoolFe\Event;

use Internetgalerie\IgDatapoolFe\Lib\FileUpload;
use Psr\EventDispatcher\StoppableEventInterface;

final class FileUploadBeforeMoveToEvent implements StoppableEventInterface {
    private ?string $uploadFolder = null;
    private ?string $fileName = null;
    private $conflictMode = null;

    public function __construct(?string $uploadFolder = null, ?string $fileName = null, $conflictMode = null)
    {
        $this->uploadFolder = $uploadFolder;
        $this->fileName = $fileName;
        $this->conflictMode = $conflictMode;
    }

    public function getFileName(): ?string
    {
        return $this->fileName;
    }

    public function setFileName(?string $fileName): void
    {
        $this->fileName = $fileName;
    }

    public function getUploadFolder(): ?string
    {
        return $this->uploadFolder;
    }

    public function setUploadFolder(?string $uploadFolder): void
    {
        $this->uploadFolder = $uploadFolder;
    }

    public function getConflictMode()
    {
        return $this->conflictMode;
    }

    public function setConflictMode($conflictMode): void
    {
        $this->conflictMode = $conflictMode;
    }

    public function isPropagationStopped(): bool
    {
        return false;
    }

}




