<?php

namespace Internetgalerie\IgDatapoolFe\Services;

class LangService implements \TYPO3\CMS\Core\SingletonInterface
{
    /**
     * public call and singleton interface for tranlsate method
     *
     * @see translate()
     */
    public static function ll($path, $extName = 'extbase', $specialContext = 'main', $arguments = array())
    {
        return self::getInstance()->translate($path, $extName, $specialContext, $arguments);
    }

    public static $instance = null;

    public static function getInstance()
    {
        if (self::$instance == null) {

            // SH: self::$instance = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\Internetgalerie\IgDatapoolFe\Services\LangService::class);
            self::$instance = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\Internetgalerie\IgDatapoolFe\Services\LangService::class);
        }
        return self::$instance;
    }

    protected $currentLabels = array();

    protected $currentExtension = '';

    /**
     * translaton utilty
     * get defaults from:
     * 1. custom labels
     * 2. current extension,
     * 3. ig datapool fe
     * 4. extbase or given name
     */
    public function translate($path, $extName = '', $specialContext = '', $arguments = array())
    {
        if ($specialContext == '') {
            $specialContext = 'main';
        }
        $out = '';

        // 1. custom label set
        $newPathOrLabel = $this->currentLabels[$specialContext][$path] ?? '';

        // 1.5 main context
        if (!$newPathOrLabel) {
            $newPathOrLabel = $this->currentLabels['main'][$path] ?? '';
        }

        if ($newPathOrLabel) {
            //try to find a label in the current extension LLL, set it if it exists
            if ($this->currentExtension && ($label = \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate($newPathOrLabel, $this->currentExtension, $arguments))) {
                $out = $label;
            } else {
                $out = $newPathOrLabel;
            }
        }
        if ($out) {
            return $out;
        }
        if ($this->currentExtension) {
            // 2. try current extension
            $out = \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate($path, $this->currentExtension, $arguments);
            if ($out) {
                return $out;
            }
        }

        // 3. try ig_render
        $out = \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate($path, 'igRender', $arguments);
        if ($out) {
            return $out;
        }

        //4. try original
        return \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate($path, $extName ? $extName : 'extbase', $arguments);
    }

    /**
     * Set a label for a custom field or overall for the current action
     */
    public function setLabel($path, $newPathOrLabel, $specialContext = 'main')
    {
        $this->currentLabels[$specialContext][$path] = $newPathOrLabel;
    }

    /**
     * initialize the langservice by setting the current extension
     */
    public function setCurrentExtension($extKey)
    {
        $this->currentExtension = $extKey;
    }
}
