<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;


use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;

class DatetimeViewHelper extends AbstractDatetimeViewHelper
{

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->overrideArgument('type', 'string', 'The field type, e.g. "text", "email", "url" etc.', false, 'datetime-local');
        $this->overrideArgument('class', 'string', 'Label', false, 'dp-datetime');
        $this->registerTagAttribute('min', 'string', 'Minimum DateTime', false);
        $this->registerTagAttribute('max', 'string', 'Maximum DateTime', false);
        $this->registerTagAttribute('step', 'string', 'Step', false);
        //$this->registerArgument('dateFormat', 'string', 'Format for output', false, 'dd.mm.yyyy');
        $this->registerArgument('formatSubmit', 'string', 'Format Submit', false, 'Y-m-d\\TH:i:s');
        $this->registerArgument('typeConverterDateFormat', 'string', 'date format for DateTimeConverter (field dateFormat)', false);
    }
    public function render(): string
    {
        $res = parent::render();
        $res .= $this->getInputDateFormat();
        return $res;
    }

}
