<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;
use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\TextfieldViewHelper;

class EasepickTimeViewHelper extends AbstractDatetimeViewHelper
{
    protected static $typeConverterFormatSubmitReplaces = [
        'HH' => 'H',
        'mm' => 'i',
        'ss' => 's',
    ];

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('dateFormat', 'string', 'Format for output', false, 'HH:mm');
        $this->registerArgument('formatSubmit', 'string', 'Format Submit', false, 'HH:mm');
        $this->registerArgument('typeConverterDateFormat', 'string', 'date format for DateTimeConverter (field dateFormat)', false);
        $this->registerArgument('hiddenName', 'bool', 'hiddenName', false, true);
        $this->registerArgument('datepickerOptions', 'string', 'Format', false, '');
        //$this->registerArgument('language', 'string', 'Sprache für JS translations File', false);// geht nur letzte auf Seite
        $this->overrideArgument('class', 'string', 'Label', false, 'dp-easepick-time');
        $this->overrideArgument('placeholder', 'string', 'Label', false, 'hh:mm');
    }

    /**
     * Renders the datefield.
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        $pageRenderer = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);

        $options = [];
        $options['format']= ($this->arguments['dateFormat']);
        $options['formatSubmit'] =  $this->arguments['formatSubmit'];
        $options['hiddenName'] = ($this->arguments['hiddenName'] ? true : false);

        if ($this->arguments['datepickerOptions']) {
            if (is_array($this->arguments['datepickerOptions'])) {
                $options = array_merge($options, $this->arguments['datepickerOptions']);
            } else {
                // support older string format
                $datepickerOptions = json_decode('{' . str_replace('\'', '"', $this->arguments['datepickerOptions']) .'}', true);
                $options = array_merge($options, $datepickerOptions);
            }
        }

        //$options = '{' .  $datepickerOptions;
        //$options = rtrim(rtrim($options), ',') . '}';

        $value = $this->getValueAttribute();

        if ($this->isObjectAccessorMode()) {
            $value = $this->getPropertyValue();
        }

        //$value = $this->convertToPlainValue($value);
        // is property Value
        if ($value instanceof \DateTime) {
            $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
            $value = $value->format($typeConverterDateFormat);
            //$value = $value->format('Y-m-d');
        }

        if(!$options['seconds']) {
            $value = substr($value, 0, -3);
        }

        $this->tag->addAttribute('data-dateoptions', json_encode($options));
        $this->tag->addAttribute('data-value', $value);

        $res = parent::render();
        //$value = $this->getValueAttribute();        var_dump($value,$res);exit(0);

        // CAVEAT: this has to match the formatSubmit (format in js: yyyy-mm-dd, format in php Y-m-d)
        $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
        //$res .= '<input type="hidden" name="' . parent::getName() . '[dateFormat]" value="' . htmlspecialchars($typeConverterDateFormat) . '" />';
        return $res;
    }
}
