<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form\Slider\Range;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IfSetViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('value', 'mixed', 'form value', true);
        $this -> registerArgument('min', 'float', 'min', false, 0);
        $this -> registerArgument('max', 'float', 'max', false, 100);
        $this -> registerArgument('step', 'float', 'step', false, 0);
    }


    /**
     * This method decides if the condition is TRUE or FALSE. It can be overriden in extending viewhelpers
     * to adjust functionality.
     *
     * @param array $arguments ViewHelper arguments to evaluate the condition for this ViewHelper, allows for
     *                         flexiblity in overriding this method.
     * @return bool
     */
    protected static function evaluateCondition($arguments = null)
    {
        $min = $arguments['min'];
        $max = $arguments['max'];
        $step = $arguments['step'];
        $value = $arguments['value'];
        if (is_array($value)) {
            $fromValue = $value['from'] ?? $min;
            $toValue = $value['to'] ?? $max;
        } else {
            $v = explode(',', $value);
            $fromValue = $v[0] ?? $min;
            $toValue = $v[1] ?? $max;
        }
        return !($min==$fromValue && $max==$toValue);
    }
}
