<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

/**
 * Creates an InfoBubble
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class InfoBubbleViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper
{
    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments()
    {
        $this -> registerArgument('text', 'string', 'Tooltip Text.', true, '');
        $this -> registerArgument('style', 'int', 'Style', false, '0');
    }

    /**
     * Renders a tooltip element
     *
     * @return string
     */
    public function render()
    {
        $GLOBALS['TSFE'] -> additionalHeaderData['ig_datapool_fe_tooltipster'] = '
<link rel="stylesheet" href="/typo3conf/ext/ig_datapool_fe/Resources/Public/Css/tooltipster.css" />';
        $GLOBALS['TSFE'] -> additionalFooterData['ig_datapool_fe_tooltipster'] = '
<script src="/typo3conf/ext/ig_datapool_fe/Resources/Public/JavaScript/jquery.tooltipster.js"></script>';
        $child = $this -> renderChildren();

        // is it a div with content or just a button
        if (trim($child) == '') {
            $class = 'dp-infobubble-button';
            $child = '&nbsp;';
        } else {
            $class = 'dp-infobubble-div';
        }
        // add a style
        $styleClass = 'dp-infobubble-style' . $this -> arguments['style'];
        $out = '<div class="' . $class . ' ' . $styleClass . '" data-infobubble="' . htmlspecialchars($this -> arguments['text']) . '" >' . $child . '</div>';
        return $out;
    }
}
